<?php

/**

 * Plugin Name: Capital ePay WooCommerce Payment Gateway

 * Plugin URI: https://wordpress.org/plugins/capital-epay-woocommerce-payment-gateway/

 * Description: Extends WooCommerce by Adding the Capital ePay Gateway.

 * Version: 2.5

 * Author: Capital District Digital

 * Author URI: https://capitaldistrictdigital.com/

 * WC requires at least: 3.0.9

 * WC tested up to: 4.6.1* 

 */



// Include our Gateway Class and register Payment Gateway with WooCommerce

add_action( 'plugins_loaded', 'spyr_capitalepay_init', 0 );

function spyr_capitalepay_init() {

	// If the parent WC_Payment_Gateway class doesn't exist

	// it means WooCommerce is not installed on the site

	// so do nothing

	if ( ! class_exists( 'WC_Payment_Gateway' ) ) return;

	

	// If we made it this far, then include our Gateway Class

	include_once( 'credit-card/class-cepay-payment-gateway-cc.php' );

	include_once( 'e-check/class-cepay-payment-gateway-echeck.php' );



	// Now that we have successfully included our class,

	// Lets add it too WooCommerce

	add_filter( 'woocommerce_payment_gateways', 'spyr_add_capitalepay_gateway' );

	

	function spyr_add_capitalepay_gateway( $methods ) {

		$methods[] = 'SPYR_CapitalePay';

		$methods[] = 'CEPAY_WC_Gateway_Cheque';

		return $methods;

	}

}



add_action('wp_enqueue_scripts','register_cepay_style');



function register_cepay_style(){

    wp_enqueue_style( 'cepay-style', plugins_url( 'assets/css/style.css' , __FILE__ ) );

}





// Add custom action links

add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'spyr_capitalepay_action_links' );

function spyr_capitalepay_action_links( $links ) {

	$plugin_links = array(

		'<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout' ) . '">' . __( 'Settings', 'spyr-capitalepay' ) . '</a>',

	);



	// Merge our new link with the default ones

	return array_merge( $plugin_links, $links );	

}