/*
* Cube Portfolio - Responsive jQuery Grid Plugin
*
* version: 4.3.2 (7 April, 2018)
* require: jQuery v1.8+
*
* Copyright 2013-2018, Mihai Buricea (http://scriptpie.com/cubeportfolio/live-preview/)
* Licensed under CodeCanyon License (http://codecanyon.net/licenses)
*
*/

!function(t,e,n,i){"use strict";function o(e,n,a){var r=this;if(t.data(e,"cubeportfolio"))throw new Error("cubeportfolio is already initialized. Destroy it before initialize again!");r.obj=e,r.$obj=t(e),t.data(r.obj,"cubeportfolio",r),n.sortToPreventGaps!==i&&(n.sortByDimension=n.sortToPreventGaps,delete n.sortToPreventGaps),r.options=t.extend({},t.fn.cubeportfolio.options,n,r.$obj.data("cbp-options")),r.isAnimating=!0,r.defaultFilter=r.options.defaultFilter,r.registeredEvents=[],r.queue=[],r.addedWrapp=!1,t.isFunction(a)&&r.registerEvent("initFinish",a,!0);var s=r.$obj.children();r.$obj.addClass("cbp"),(0===s.length||s.first().hasClass("cbp-item"))&&(r.wrapInner(r.obj,"cbp-wrapper"),r.addedWrapp=!0),r.$ul=r.$obj.children().addClass("cbp-wrapper"),r.wrapInner(r.obj,"cbp-wrapper-outer"),r.wrapper=r.$obj.children(".cbp-wrapper-outer"),r.blocks=r.$ul.children(".cbp-item"),r.blocksOn=r.blocks,r.wrapInner(r.blocks,"cbp-item-wrapper"),r.plugins={},t.each(o.plugins,function(t,e){var n=e(r);n&&(r.plugins[t]=n)}),r.triggerEvent("afterPlugins"),r.removeAttrAfterStoreData=t.Deferred(),r.loadImages(r.$obj,r.display)}t.extend(o.prototype,{storeData:function(e,n){var i=this;n=n||0,e.each(function(e,o){var a=t(o),r=a.width(),s=a.height();a.data("cbp",{index:n+e,indexInitial:n+e,wrapper:a.children(".cbp-item-wrapper"),widthInitial:r,heightInitial:s,width:r,height:s,widthAndGap:r+i.options.gapVertical,heightAndGap:s+i.options.gapHorizontal,left:null,leftNew:null,top:null,topNew:null,pack:!1})}),this.removeAttrAfterStoreData.resolve()},wrapInner:function(t,e){var o,a,r;if(e=e||"",!(t.length&&t.length<1))for(t.length===i&&(t=[t]),a=t.length-1;a>=0;a--){for(o=t[a],(r=n.createElement("div")).setAttribute("class",e);o.childNodes.length;)r.appendChild(o.childNodes[0]);o.appendChild(r)}},removeAttrImage:function(t){this.removeAttrAfterStoreData.then(function(){t.removeAttribute("width"),t.removeAttribute("height"),t.removeAttribute("style")})},loadImages:function(e,n){var i=this;requestAnimationFrame(function(){var o=e.find("img").map(function(e,n){if(n.hasAttribute("width")&&n.hasAttribute("height")){if(n.style.width=n.getAttribute("width")+"px",n.style.height=n.getAttribute("height")+"px",n.hasAttribute("data-cbp-src"))return null;if(null===i.checkSrc(n))i.removeAttrImage(n);else{var o=t("<img>");o.on("load.cbp error.cbp",function(){t(this).off("load.cbp error.cbp"),i.removeAttrImage(n)}),n.srcset?(o.attr("sizes",n.sizes||"100vw"),o.attr("srcset",n.srcset)):o.attr("src",n.src)}return null}return i.checkSrc(n)}),a=o.length;0!==a?t.each(o,function(e,o){var r=t("<img>");r.on("load.cbp error.cbp",function(){t(this).off("load.cbp error.cbp"),0===--a&&n.call(i)}),o.srcset?(r.attr("sizes",o.sizes),r.attr("srcset",o.srcset)):r.attr("src",o.src)}):n.call(i)})},checkSrc:function(e){var n=e.srcset,o=e.src;if(""===o)return null;var a=t("<img>");n?(a.attr("sizes",e.sizes||"100vw"),a.attr("srcset",n)):a.attr("src",o);var r=a[0];return r.complete&&r.naturalWidth!==i&&0!==r.naturalWidth?null:r},display:function(){var t=this;t.width=t.$obj.outerWidth(),t.triggerEvent("initStartRead"),t.triggerEvent("initStartWrite"),t.width>0&&(t.storeData(t.blocks),t.layoutAndAdjustment()),t.triggerEvent("initEndRead"),t.triggerEvent("initEndWrite"),t.$obj.addClass("cbp-ready"),t.runQueue("delayFrame",t.delayFrame)},delayFrame:function(){var t=this;requestAnimationFrame(function(){t.resizeEvent(),t.triggerEvent("initFinish"),t.isAnimating=!1,t.$obj.trigger("initComplete.cbp")})},resizeEvent:function(){var t=this;o["private"].resize.initEvent({instance:t,fn:function(){t.triggerEvent("beforeResizeGrid");var e=t.$obj.outerWidth();e&&t.width!==e&&(t.width=e,"alignCenter"===t.options.gridAdjustment&&(t.wrapper[0].style.maxWidth=""),t.layoutAndAdjustment(),t.triggerEvent("resizeGrid")),t.triggerEvent("resizeWindow")}})},gridAdjust:function(){var e=this;"responsive"===e.options.gridAdjustment?e.responsiveLayout():(e.blocks.removeAttr("style"),e.blocks.each(function(n,i){var o=t(i).data("cbp"),a=i.getBoundingClientRect(),r=e.columnWidthTruncate(a.right-a.left),s=Math.round(a.bottom-a.top);o.height=s,o.heightAndGap=s+e.options.gapHorizontal,o.width=r,o.widthAndGap=r+e.options.gapVertical}),e.widthAvailable=e.width+e.options.gapVertical),e.triggerEvent("gridAdjust")},layoutAndAdjustment:function(t){t&&(this.width=this.$obj.outerWidth()),this.gridAdjust(),this.layout()},layout:function(){var e=this;e.computeBlocks(e.filterConcat(e.defaultFilter)),"slider"===e.options.layoutMode?(e.sliderLayoutReset(),e.sliderLayout()):(e.mosaicLayoutReset(),e.mosaicLayout()),e.blocksOff.addClass("cbp-item-off"),e.blocksOn.removeClass("cbp-item-off").each(function(e,n){var i=t(n).data("cbp");i.left=i.leftNew,i.top=i.topNew,n.style.left=i.left+"px",n.style.top=i.top+"px"}),e.resizeMainContainer()},computeFilter:function(t){this.computeBlocks(t),this.mosaicLayoutReset(),this.mosaicLayout(),this.filterLayout()},filterLayout:function(){this.blocksOff.addClass("cbp-item-off"),this.blocksOn.removeClass("cbp-item-off").each(function(e,n){var i=t(n).data("cbp");i.left=i.leftNew,i.top=i.topNew,n.style.left=i.left+"px",n.style.top=i.top+"px"}),this.resizeMainContainer(),this.filterFinish()},filterFinish:function(){this.isAnimating=!1,this.$obj.trigger("filterComplete.cbp"),this.triggerEvent("filterFinish")},computeBlocks:function(t){var e=this;e.blocksOnInitial=e.blocksOn,e.blocksOn=e.blocks.filter(t),e.blocksOff=e.blocks.not(t),e.triggerEvent("computeBlocksFinish",t)},responsiveLayout:function(){var e=this;e.cols=e[t.isArray(e.options.mediaQueries)?"getColumnsBreakpoints":"getColumnsAuto"](),e.columnWidth=e.columnWidthTruncate((e.width+e.options.gapVertical)/e.cols),e.widthAvailable=e.columnWidth*e.cols,"mosaic"===e.options.layoutMode&&e.getMosaicWidthReference(),e.blocks.each(function(n,i){var o,a=t(i).data("cbp"),r=1;"mosaic"===e.options.layoutMode&&(r=e.getColsMosaic(a.widthInitial)),o=e.columnWidth*r-e.options.gapVertical,i.style.width=o+"px",a.width=o,a.widthAndGap=o+e.options.gapVertical,i.style.height=""});var n=[];e.blocks.each(function(e,i){t.each(t(i).find("img").filter("[width][height]"),function(e,i){var o=0;t(i).parentsUntil(".cbp-item").each(function(e,n){var i=t(n).width();if(i>0)return o=i,!1});var a=parseInt(i.getAttribute("width"),10),r=parseInt(i.getAttribute("height"),10),s=parseFloat((a/r).toFixed(10));n.push({el:i,width:o,height:Math.round(o/s)})})}),t.each(n,function(t,e){e.el.width=e.width,e.el.height=e.height,e.el.style.width=e.width+"px",e.el.style.height=e.height+"px"}),e.blocks.each(function(n,i){var o=t(i).data("cbp"),a=i.getBoundingClientRect(),r=Math.round(a.bottom-a.top);o.height=r,o.heightAndGap=r+e.options.gapHorizontal})},getMosaicWidthReference:function(){var e=[];this.blocks.each(function(n,i){var o=t(i).data("cbp");e.push(o.widthInitial)}),e.sort(function(t,e){return t-e}),e[0]?this.mosaicWidthReference=e[0]:this.mosaicWidthReference=this.columnWidth},getColsMosaic:function(t){if(t===this.width)return this.cols;var e=t/this.mosaicWidthReference;return e=e%1>=.79?Math.ceil(e):Math.floor(e),Math.min(Math.max(e,1),this.cols)},getColumnsAuto:function(){if(0===this.blocks.length)return 1;var t=this.blocks.first().data("cbp").widthInitial+this.options.gapVertical;return Math.max(Math.round(this.width/t),1)},getColumnsBreakpoints:function(){var e,n=this,i=n.width;return t.each(n.options.mediaQueries,function(t,n){if(i>=n.width)return e=n,!1}),e||(e=n.options.mediaQueries[n.options.mediaQueries.length-1]),n.triggerEvent("onMediaQueries",e.options),e.cols},columnWidthTruncate:function(t){return Math.floor(t)},resizeMainContainer:function(){var e,n=this,a=Math.max(n.freeSpaces.slice(-1)[0].topStart-n.options.gapHorizontal,0);"alignCenter"===n.options.gridAdjustment&&(e=0,n.blocksOn.each(function(n,i){var o=t(i).data("cbp"),a=o.left+o.width;a>e&&(e=a)}),n.wrapper[0].style.maxWidth=e+"px"),a!==n.height?(n.obj.style.height=a+"px",n.height!==i&&(o["private"].modernBrowser?n.$obj.one(o["private"].transitionend,function(){n.$obj.trigger("pluginResize.cbp")}):n.$obj.trigger("pluginResize.cbp")),n.height=a,n.triggerEvent("resizeMainContainer")):n.triggerEvent("resizeMainContainer")},filterConcat:function(t){return t.replace(/\|/gi,"")},pushQueue:function(t,e){this.queue[t]=this.queue[t]||[],this.queue[t].push(e)},runQueue:function(e,n){var i=this.queue[e]||[];t.when.apply(t,i).then(t.proxy(n,this))},clearQueue:function(t){this.queue[t]=[]},registerEvent:function(t,e,n){this.registeredEvents[t]||(this.registeredEvents[t]=[]),this.registeredEvents[t].push({func:e,oneTime:n||!1})},triggerEvent:function(t,e){var n,i,o=this;if(o.registeredEvents[t])for(n=0,i=o.registeredEvents[t].length;n<i;n++)o.registeredEvents[t][n].func.call(o,e),o.registeredEvents[t][n].oneTime&&(o.registeredEvents[t].splice(n,1),n--,i--)},addItems:function(e,n,i){var a=this;a.wrapInner(e,"cbp-item-wrapper"),a.$ul[i](e.addClass("cbp-item-loading").css({top:"100%",left:0})),o["private"].modernBrowser?e.last().one(o["private"].animationend,function(){a.addItemsFinish(e,n)}):a.addItemsFinish(e,n),a.loadImages(e,function(){if(a.$obj.addClass("cbp-updateItems"),"append"===i)a.storeData(e,a.blocks.length),t.merge(a.blocks,e);else{a.storeData(e);var n=e.length;a.blocks.each(function(e,i){t(i).data("cbp").index=n+e}),a.blocks=t.merge(e,a.blocks)}a.triggerEvent("addItemsToDOM",e),a.triggerEvent("triggerSort"),a.layoutAndAdjustment(!0),a.elems&&o["public"].showCounter.call(a.obj,a.elems)})},addItemsFinish:function(e,n){this.isAnimating=!1,this.$obj.removeClass("cbp-updateItems"),e.removeClass("cbp-item-loading"),t.isFunction(n)&&n.call(this,e),this.$obj.trigger("onAfterLoadMore.cbp",[e])},removeItems:function(e,n){var i=this;i.$obj.addClass("cbp-updateItems"),o["private"].modernBrowser?e.last().one(o["private"].animationend,function(){i.removeItemsFinish(e,n)}):i.removeItemsFinish(e,n),e.each(function(e,n){i.blocks.each(function(e,a){if(n===a){var r=t(a);i.blocks.splice(e,1),o["private"].modernBrowser?(r.one(o["private"].animationend,function(){r.remove()}),r.addClass("cbp-removeItem")):r.remove()}})}),i.blocks.each(function(e,n){t(n).data("cbp").index=e}),i.triggerEvent("triggerSort"),i.layoutAndAdjustment(!0),i.elems&&o["public"].showCounter.call(i.obj,i.elems)},removeItemsFinish:function(e,n){this.isAnimating=!1,this.$obj.removeClass("cbp-updateItems"),t.isFunction(n)&&n.call(this,e)}}),t.fn.cubeportfolio=function(t,e,n){return this.each(function(){if("object"==typeof t||!t)return o["public"].init.call(this,t,e);if(o["public"][t])return o["public"][t].call(this,e,n);throw new Error("Method "+t+" does not exist on jquery.cubeportfolio.js")})},o.plugins={},t.fn.cubeportfolio.constructor=o}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;t.extend(o.prototype,{mosaicLayoutReset:function(){var e=this;e.blocksAreSorted=!1,e.blocksOn.each(function(n,i){t(i).data("cbp").pack=!1,e.options.sortByDimension&&(i.style.height="")}),e.freeSpaces=[{leftStart:0,leftEnd:e.widthAvailable,topStart:0,topEnd:Math.pow(2,18)}]},mosaicLayout:function(){for(var t=this,e=0,n=t.blocksOn.length;e<n;e++){var i=t.getSpaceIndexAndBlock();if(null===i)return t.mosaicLayoutReset(),t.blocksAreSorted=!0,t.sortBlocks(t.blocksOn,"widthAndGap","heightAndGap",!0),void t.mosaicLayout();t.generateF1F2(i.spaceIndex,i.dataBlock),t.generateG1G2G3G4(i.dataBlock),t.cleanFreeSpaces(),t.addHeightToBlocks()}t.blocksAreSorted&&t.sortBlocks(t.blocksOn,"topNew","leftNew")},getSpaceIndexAndBlock:function(){var e=this,n=null;return t.each(e.freeSpaces,function(i,o){var a=o.leftEnd-o.leftStart,r=o.topEnd-o.topStart;return e.blocksOn.each(function(e,s){var l=t(s).data("cbp");if(!0!==l.pack)return l.widthAndGap<=a&&l.heightAndGap<=r?(l.pack=!0,n={spaceIndex:i,dataBlock:l},l.leftNew=o.leftStart,l.topNew=o.topStart,!1):void 0}),!e.blocksAreSorted&&e.options.sortByDimension&&i>0?(n=null,!1):null===n&&void 0}),n},generateF1F2:function(t,e){var n=this.freeSpaces[t],i={leftStart:n.leftStart+e.widthAndGap,leftEnd:n.leftEnd,topStart:n.topStart,topEnd:n.topEnd},o={leftStart:n.leftStart,leftEnd:n.leftEnd,topStart:n.topStart+e.heightAndGap,topEnd:n.topEnd};this.freeSpaces.splice(t,1),i.leftEnd>i.leftStart&&i.topEnd>i.topStart&&(this.freeSpaces.splice(t,0,i),t++),o.leftEnd>o.leftStart&&o.topEnd>o.topStart&&this.freeSpaces.splice(t,0,o)},generateG1G2G3G4:function(e){var n=this,i=[];t.each(n.freeSpaces,function(t,o){var a=n.intersectSpaces(o,e);null!==a?(n.generateG1(o,a,i),n.generateG2(o,a,i),n.generateG3(o,a,i),n.generateG4(o,a,i)):i.push(o)}),n.freeSpaces=i},intersectSpaces:function(t,e){var n={leftStart:e.leftNew,leftEnd:e.leftNew+e.widthAndGap,topStart:e.topNew,topEnd:e.topNew+e.heightAndGap};if(t.leftStart===n.leftStart&&t.leftEnd===n.leftEnd&&t.topStart===n.topStart&&t.topEnd===n.topEnd)return null;var i=Math.max(t.leftStart,n.leftStart),o=Math.min(t.leftEnd,n.leftEnd),a=Math.max(t.topStart,n.topStart),r=Math.min(t.topEnd,n.topEnd);return o<=i||r<=a?null:{leftStart:i,leftEnd:o,topStart:a,topEnd:r}},generateG1:function(t,e,n){t.topStart!==e.topStart&&n.push({leftStart:t.leftStart,leftEnd:t.leftEnd,topStart:t.topStart,topEnd:e.topStart})},generateG2:function(t,e,n){t.leftEnd!==e.leftEnd&&n.push({leftStart:e.leftEnd,leftEnd:t.leftEnd,topStart:t.topStart,topEnd:t.topEnd})},generateG3:function(t,e,n){t.topEnd!==e.topEnd&&n.push({leftStart:t.leftStart,leftEnd:t.leftEnd,topStart:e.topEnd,topEnd:t.topEnd})},generateG4:function(t,e,n){t.leftStart!==e.leftStart&&n.push({leftStart:t.leftStart,leftEnd:e.leftStart,topStart:t.topStart,topEnd:t.topEnd})},cleanFreeSpaces:function(){this.freeSpaces.sort(function(t,e){return t.topStart>e.topStart?1:t.topStart<e.topStart?-1:t.leftStart>e.leftStart?1:t.leftStart<e.leftStart?-1:0}),this.correctSubPixelValues(),this.removeNonMaximalFreeSpaces()},correctSubPixelValues:function(){var t,e,n,i;for(t=0,e=this.freeSpaces.length-1;t<e;t++)n=this.freeSpaces[t],(i=this.freeSpaces[t+1]).topStart-n.topStart<=1&&(i.topStart=n.topStart)},removeNonMaximalFreeSpaces:function(){var e=this;e.uniqueFreeSpaces(),e.freeSpaces=t.map(e.freeSpaces,function(n,i){return t.each(e.freeSpaces,function(t,e){if(i!==t)return e.leftStart<=n.leftStart&&e.leftEnd>=n.leftEnd&&e.topStart<=n.topStart&&e.topEnd>=n.topEnd?(n=null,!1):void 0}),n})},uniqueFreeSpaces:function(){var e=[];t.each(this.freeSpaces,function(n,i){t.each(e,function(t,e){if(e.leftStart===i.leftStart&&e.leftEnd===i.leftEnd&&e.topStart===i.topStart&&e.topEnd===i.topEnd)return i=null,!1}),null!==i&&e.push(i)}),this.freeSpaces=e},addHeightToBlocks:function(){var e=this;t.each(e.freeSpaces,function(n,i){e.blocksOn.each(function(n,o){var a=t(o).data("cbp");!0===a.pack&&(e.intersectSpaces(i,a)&&-1===i.topStart-a.topNew-a.heightAndGap&&(o.style.height=a.height-1+"px"))})})},sortBlocks:function(e,n,i,o){i=void 0===i?"leftNew":i,o=void 0===o?1:-1,e.sort(function(e,a){var r=t(e).data("cbp"),s=t(a).data("cbp");return r[n]>s[n]?o:r[n]<s[n]?-o:r[i]>s[i]?o:r[i]<s[i]?-o:r.index>s.index?o:r.index<s.index?-o:void 0})}})}(jQuery,window,document),jQuery.fn.cubeportfolio.options={filters:"",search:"",layoutMode:"grid",sortByDimension:!1,drag:!0,auto:!1,autoTimeout:5e3,autoPauseOnHover:!0,showNavigation:!0,showPagination:!0,rewindNav:!0,scrollByPage:!1,defaultFilter:"*",filterDeeplinking:!1,animationType:"fadeOut",gridAdjustment:"responsive",mediaQueries:!1,gapHorizontal:10,gapVertical:10,caption:"pushTop",displayType:"fadeIn",displayTypeSpeed:400,lightboxDelegate:".cbp-lightbox",lightboxGallery:!0,lightboxTitleSrc:"data-title",lightboxCounter:'<div class="cbp-popup-lightbox-counter">{{current}} of {{total}}</div>',singlePageDelegate:".cbp-singlePage",singlePageDeeplinking:!0,singlePageStickyNavigation:!0,singlePageCounter:'<div class="cbp-popup-singlePage-counter">{{current}} of {{total}}</div>',singlePageAnimation:"left",singlePageCallback:null,singlePageInlineDelegate:".cbp-singlePageInline",singlePageInlineDeeplinking:!1,singlePageInlinePosition:"top",singlePageInlineInFocus:!0,singlePageInlineCallback:null,plugins:{}},function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor,a=t(e);o["private"]={publicEvents:function(e,n,i){var o=this;o.events=[],o.initEvent=function(t){0===o.events.length&&o.scrollEvent(),o.events.push(t)},o.destroyEvent=function(n){o.events=t.map(o.events,function(t,e){if(t.instance!==n)return t}),0===o.events.length&&a.off(e)},o.scrollEvent=function(){var r;a.on(e,function(){clearTimeout(r),r=setTimeout(function(){t.isFunction(i)&&i.call(o)||t.each(o.events,function(t,e){e.fn.call(e.instance)})},n)})}},checkInstance:function(e){var n=t.data(this,"cubeportfolio");if(!n)throw new Error("cubeportfolio is not initialized. Initialize it before calling "+e+" method!");return n.triggerEvent("publicMethod"),n},browserInfo:function(){var t,n,i=o["private"],a=navigator.appVersion;-1!==a.indexOf("MSIE 8.")?i.browser="ie8":-1!==a.indexOf("MSIE 9.")?i.browser="ie9":-1!==a.indexOf("MSIE 10.")?i.browser="ie10":e.ActiveXObject||"ActiveXObject"in e?i.browser="ie11":/android/gi.test(a)?i.browser="android":/iphone|ipad|ipod/gi.test(a)?i.browser="ios":/chrome/gi.test(a)?i.browser="chrome":i.browser="",void 0!==typeof i.styleSupport("perspective")&&(t=i.styleSupport("transition"),i.transitionend={WebkitTransition:"webkitTransitionEnd",transition:"transitionend"}[t],n=i.styleSupport("animation"),i.animationend={WebkitAnimation:"webkitAnimationEnd",animation:"animationend"}[n],i.animationDuration={WebkitAnimation:"webkitAnimationDuration",animation:"animationDuration"}[n],i.animationDelay={WebkitAnimation:"webkitAnimationDelay",animation:"animationDelay"}[n],i.transform=i.styleSupport("transform"),t&&n&&i.transform&&(i.modernBrowser=!0))},styleSupport:function(t){var e,i="Webkit"+t.charAt(0).toUpperCase()+t.slice(1),o=n.createElement("div");return t in o.style?e=t:i in o.style&&(e=i),o=null,e}},o["private"].browserInfo(),o["private"].resize=new o["private"].publicEvents("resize.cbp",50,function(){if(e.innerHeight==screen.height)return!0})}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;o["public"]={init:function(t,e){new o(this,t,e)},destroy:function(e){var n=o["private"].checkInstance.call(this,"destroy");n.triggerEvent("beforeDestroy"),t.removeData(this,"cubeportfolio"),n.blocks.removeData("cbp"),n.$obj.removeClass("cbp-ready").removeAttr("style"),n.$ul.removeClass("cbp-wrapper"),o["private"].resize.destroyEvent(n),n.$obj.off(".cbp"),n.blocks.removeClass("cbp-item-off").removeAttr("style"),n.blocks.find(".cbp-item-wrapper").each(function(e,n){var i=t(n),o=i.children();o.length?o.unwrap():i.remove()}),n.destroySlider&&n.destroySlider(),n.$ul.unwrap(),n.addedWrapp&&n.blocks.unwrap(),0===n.blocks.length&&n.$ul.remove(),t.each(n.plugins,function(t,e){"function"==typeof e.destroy&&e.destroy()}),t.isFunction(e)&&e.call(n),n.triggerEvent("afterDestroy")},filter:function(e,n){var i,a=o["private"].checkInstance.call(this,"filter");if(!a.isAnimating){if(a.isAnimating=!0,t.isFunction(n)&&a.registerEvent("filterFinish",n,!0),t.isFunction(e)){if(void 0===(i=e.call(a,a.blocks)))throw new Error("When you call cubeportfolio API `filter` method with a param of type function you must return the blocks that will be visible.")}else{if(a.options.filterDeeplinking){var r=location.href.replace(/#cbpf=(.*?)([#\?&]|$)/gi,"");location.href=r+"#cbpf="+encodeURIComponent(e),a.singlePage&&a.singlePage.url&&(a.singlePage.url=location.href)}a.defaultFilter=e,i=a.filterConcat(a.defaultFilter)}a.triggerEvent("filterStart",i),a.singlePageInline&&a.singlePageInline.isOpen?a.singlePageInline.close("promise",{callback:function(){a.computeFilter(i)}}):a.computeFilter(i)}},showCounter:function(e,n){var i=o["private"].checkInstance.call(this,"showCounter");t.isFunction(n)&&i.registerEvent("showCounterFinish",n,!0),i.elems=e,e.each(function(){var e=t(this),n=i.blocks.filter(e.data("filter")).length;e.find(".cbp-filter-counter").text(n)}),i.triggerEvent("showCounterFinish",e)},appendItems:function(t,e){o["public"].append.call(this,t,e)},append:function(e,n){var i=o["private"].checkInstance.call(this,"append"),a=t(e).filter(".cbp-item");i.isAnimating||a.length<1?t.isFunction(n)&&n.call(i,a):(i.isAnimating=!0,i.singlePageInline&&i.singlePageInline.isOpen?i.singlePageInline.close("promise",{callback:function(){i.addItems(a,n,"append")}}):i.addItems(a,n,"append"))},prepend:function(e,n){var i=o["private"].checkInstance.call(this,"prepend"),a=t(e).filter(".cbp-item");i.isAnimating||a.length<1?t.isFunction(n)&&n.call(i,a):(i.isAnimating=!0,i.singlePageInline&&i.singlePageInline.isOpen?i.singlePageInline.close("promise",{callback:function(){i.addItems(a,n,"prepend")}}):i.addItems(a,n,"prepend"))},remove:function(e,n){var i=o["private"].checkInstance.call(this,"remove"),a=t(e).filter(".cbp-item");i.isAnimating||a.length<1?t.isFunction(n)&&n.call(i,a):(i.isAnimating=!0,i.singlePageInline&&i.singlePageInline.isOpen?i.singlePageInline.close("promise",{callback:function(){i.removeItems(a,n)}}):i.removeItems(a,n))},layout:function(e){var n=o["private"].checkInstance.call(this,"layout");n.width=n.$obj.outerWidth(),n.isAnimating||n.width<=0?t.isFunction(e)&&e.call(n):("alignCenter"===n.options.gridAdjustment&&(n.wrapper[0].style.maxWidth=""),n.storeData(n.blocks),n.layoutAndAdjustment(),t.isFunction(e)&&e.call(n))}}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;t.extend(o.prototype,{updateSliderPagination:function(){var e,n,i=this;if(i.options.showPagination){for(e=Math.ceil(i.blocksOn.length/i.cols),i.navPagination.empty(),n=e-1;n>=0;n--)t("<div/>",{"class":"cbp-nav-pagination-item","data-slider-action":"jumpTo"}).appendTo(i.navPagination);i.navPaginationItems=i.navPagination.children()}i.enableDisableNavSlider()},destroySlider:function(){var e=this;"slider"===e.options.layoutMode&&(e.$obj.removeClass("cbp-mode-slider"),e.$ul.removeAttr("style"),e.$ul.off(".cbp"),t(n).off(".cbp"),e.options.auto&&e.stopSliderAuto())},nextSlider:function(t){var e=this;if(e.isEndSlider()){if(!e.isRewindNav())return;e.sliderActive=0}else e.options.scrollByPage?e.sliderActive=Math.min(e.sliderActive+e.cols,e.blocksOn.length-e.cols):e.sliderActive+=1;e.goToSlider()},prevSlider:function(t){var e=this;if(e.isStartSlider()){if(!e.isRewindNav())return;e.sliderActive=e.blocksOn.length-e.cols}else e.options.scrollByPage?e.sliderActive=Math.max(0,e.sliderActive-e.cols):e.sliderActive-=1;e.goToSlider()},jumpToSlider:function(t){var e=this,n=Math.min(t.index()*e.cols,e.blocksOn.length-e.cols);n!==e.sliderActive&&(e.sliderActive=n,e.goToSlider())},jumpDragToSlider:function(t){var e,n,i,o=this,a=t>0;o.options.scrollByPage?(e=o.cols*o.columnWidth,n=o.cols):(e=o.columnWidth,n=1),t=Math.abs(t),i=Math.floor(t/e)*n,t%e>20&&(i+=n),o.sliderActive=a?Math.min(o.sliderActive+i,o.blocksOn.length-o.cols):Math.max(0,o.sliderActive-i),o.goToSlider()},isStartSlider:function(){return 0===this.sliderActive},isEndSlider:function(){return this.sliderActive+this.cols>this.blocksOn.length-1},goToSlider:function(){this.enableDisableNavSlider(),this.updateSliderPosition()},startSliderAuto:function(){var t=this;t.isDrag?t.stopSliderAuto():t.timeout=setTimeout(function(){t.nextSlider(),t.startSliderAuto()},t.options.autoTimeout)},stopSliderAuto:function(){clearTimeout(this.timeout)},enableDisableNavSlider:function(){var t,e,n=this;n.isRewindNav()||(e=n.isStartSlider()?"addClass":"removeClass",n.navPrev[e]("cbp-nav-stop"),e=n.isEndSlider()?"addClass":"removeClass",n.navNext[e]("cbp-nav-stop")),n.options.showPagination&&(t=n.options.scrollByPage?Math.ceil(n.sliderActive/n.cols):n.isEndSlider()?n.navPaginationItems.length-1:Math.floor(n.sliderActive/n.cols),n.navPaginationItems.removeClass("cbp-nav-pagination-active").eq(t).addClass("cbp-nav-pagination-active")),n.customPagination&&(t=n.options.scrollByPage?Math.ceil(n.sliderActive/n.cols):n.isEndSlider()?n.customPaginationItems.length-1:Math.floor(n.sliderActive/n.cols),n.customPaginationItems.removeClass(n.customPaginationClass).eq(t).addClass(n.customPaginationClass))},isRewindNav:function(){return!this.options.showNavigation||!(this.blocksOn.length<=this.cols)&&!!this.options.rewindNav},sliderItemsLength:function(){return this.blocksOn.length<=this.cols},sliderLayout:function(){var e=this;e.blocksOn.each(function(n,i){var o=t(i).data("cbp");o.leftNew=e.columnWidth*n,o.topNew=0,e.sliderFreeSpaces.push({topStart:o.heightAndGap})}),e.getFreeSpacesForSlider(),e.$ul.width(e.columnWidth*e.blocksOn.length-e.options.gapVertical)},getFreeSpacesForSlider:function(){var t=this;t.freeSpaces=t.sliderFreeSpaces.slice(t.sliderActive,t.sliderActive+t.cols),t.freeSpaces.sort(function(t,e){return t.topStart>e.topStart?1:t.topStart<e.topStart?-1:void 0})},updateSliderPosition:function(){var t=this,e=-t.sliderActive*t.columnWidth;o["private"].modernBrowser?t.$ul[0].style[o["private"].transform]="translate3d("+e+"px, 0px, 0)":t.$ul[0].style.left=e+"px",t.getFreeSpacesForSlider(),t.resizeMainContainer()},dragSlider:function(){var a,r,s,l,p,c=this,u=t(n),d=!1,f={},g=!1;function h(t){c.$obj.removeClass("cbp-mode-slider-dragStart"),d=!0,0!==r?(s.one("click.cbp",function(t){return!1}),requestAnimationFrame(function(){c.jumpDragToSlider(r),c.$ul.one(o["private"].transitionend,v)})):v.call(c),u.off(f.move),u.off(f.end)}function b(t){((r=a-m(t).x)>8||r<-8)&&t.preventDefault(),c.isDrag=!0;var e=l-r;r<0&&r<l?e=(l-r)/5:r>0&&l-r<-p&&(e=(p+l-r)/5-p),o["private"].modernBrowser?c.$ul[0].style[o["private"].transform]="translate3d("+e+"px, 0px, 0)":c.$ul[0].style.left=e+"px"}function v(){if(d=!1,c.isDrag=!1,c.options.auto){if(c.mouseIsEntered)return;c.startSliderAuto()}}function m(t){return t.originalEvent!==i&&t.originalEvent.touches!==i&&(t=t.originalEvent.touches[0]),{x:t.pageX,y:t.pageY}}c.isDrag=!1,"ontouchstart"in e||navigator.maxTouchPoints>0||navigator.msMaxTouchPoints>0?(f={start:"touchstart.cbp",move:"touchmove.cbp",end:"touchend.cbp"},g=!0):f={start:"mousedown.cbp",move:"mousemove.cbp",end:"mouseup.cbp"},c.$ul.on(f.start,function(e){c.sliderItemsLength()||(g?e:e.preventDefault(),c.options.auto&&c.stopSliderAuto(),d?t(s).one("click.cbp",function(){return!1}):(s=t(e.target),a=m(e).x,r=0,l=-c.sliderActive*c.columnWidth,p=c.columnWidth*(c.blocksOn.length-c.cols),u.on(f.move,b),u.on(f.end,h),c.$obj.addClass("cbp-mode-slider-dragStart")))})},sliderLayoutReset:function(){this.freeSpaces=[],this.sliderFreeSpaces=[]}})}(jQuery,window,document),"function"!=typeof Object.create&&(Object.create=function(t){function e(){}return e.prototype=t,new e}),function(){for(var t=0,e=["moz","webkit"],n=0;n<e.length&&!window.requestAnimationFrame;n++)window.requestAnimationFrame=window[e[n]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[e[n]+"CancelAnimationFrame"]||window[e[n]+"CancelRequestAnimationFrame"];window.requestAnimationFrame||(window.requestAnimationFrame=function(e,n){var i=(new Date).getTime(),o=Math.max(0,16-(i-t)),a=window.setTimeout(function(){e(i+o)},o);return t=i+o,a}),window.cancelAnimationFrame||(window.cancelAnimationFrame=function(t){clearTimeout(t)})}(),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;function a(t){this.parent=t,t.filterLayout=this.filterLayout,t.registerEvent("computeBlocksFinish",function(e){t.blocksOn2On=t.blocksOnInitial.filter(e),t.blocksOn2Off=t.blocksOnInitial.not(e)})}a.prototype.filterLayout=function(){var e=this;function n(){e.blocks.removeClass("cbp-item-on2off cbp-item-off2on cbp-item-on2on").each(function(e,n){var i=t(n).data("cbp");i.left=i.leftNew,i.top=i.topNew,n.style.left=i.left+"px",n.style.top=i.top+"px",n.style[o["private"].transform]=""}),e.blocksOff.addClass("cbp-item-off"),e.$obj.removeClass("cbp-animation-"+e.options.animationType),e.filterFinish()}e.$obj.addClass("cbp-animation-"+e.options.animationType),e.blocksOn2On.addClass("cbp-item-on2on").each(function(e,n){var i=t(n).data("cbp");n.style[o["private"].transform]="translate3d("+(i.leftNew-i.left)+"px, "+(i.topNew-i.top)+"px, 0)"}),e.blocksOn2Off.addClass("cbp-item-on2off"),e.blocksOff2On=e.blocksOn.filter(".cbp-item-off").removeClass("cbp-item-off").addClass("cbp-item-off2on").each(function(e,n){var i=t(n).data("cbp");n.style.left=i.leftNew+"px",n.style.top=i.topNew+"px"}),e.blocksOn2Off.length?e.blocksOn2Off.last().data("cbp").wrapper.one(o["private"].animationend,n):e.blocksOff2On.length?e.blocksOff2On.last().data("cbp").wrapper.one(o["private"].animationend,n):e.blocksOn2On.length?e.blocksOn2On.last().one(o["private"].transitionend,n):n(),e.resizeMainContainer()},a.prototype.destroy=function(){var t=this.parent;t.$obj.removeClass("cbp-animation-"+t.options.animationType)},o.plugins.animationClassic=function(e){return!o["private"].modernBrowser||t.inArray(e.options.animationType,["boxShadow","fadeOut","flipBottom","flipOut","quicksand","scaleSides","skew"])<0?null:new a(e)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;function a(t){this.parent=t,t.filterLayout=this.filterLayout}a.prototype.filterLayout=function(){var e=this,n=e.$ul[0].cloneNode(!0);function i(){e.wrapper[0].removeChild(n),"sequentially"===e.options.animationType&&e.blocksOn.each(function(e,n){t(n).data("cbp").wrapper[0].style[o["private"].animationDelay]=""}),e.$obj.removeClass("cbp-animation-"+e.options.animationType),e.filterFinish()}n.setAttribute("class","cbp-wrapper-helper"),e.wrapper[0].insertBefore(n,e.$ul[0]),requestAnimationFrame(function(){e.$obj.addClass("cbp-animation-"+e.options.animationType),e.blocksOff.addClass("cbp-item-off"),e.blocksOn.removeClass("cbp-item-off").each(function(n,i){var a=t(i).data("cbp");a.left=a.leftNew,a.top=a.topNew,i.style.left=a.left+"px",i.style.top=a.top+"px","sequentially"===e.options.animationType&&(a.wrapper[0].style[o["private"].animationDelay]=60*n+"ms")}),e.blocksOn.length?e.blocksOn.last().data("cbp").wrapper.one(o["private"].animationend,i):e.blocksOnInitial.length?e.blocksOnInitial.last().data("cbp").wrapper.one(o["private"].animationend,i):i(),e.resizeMainContainer()})},a.prototype.destroy=function(){var t=this.parent;t.$obj.removeClass("cbp-animation-"+t.options.animationType)},o.plugins.animationClone=function(e){return!o["private"].modernBrowser||t.inArray(e.options.animationType,["fadeOutTop","slideLeft","sequentially"])<0?null:new a(e)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;function a(t){this.parent=t,t.filterLayout=this.filterLayout}a.prototype.filterLayout=function(){var e=this,n=e.$ul.clone(!0,!0);n[0].setAttribute("class","cbp-wrapper-helper"),e.wrapper[0].insertBefore(n[0],e.$ul[0]);var i=n.find(".cbp-item").not(".cbp-item-off");function a(){e.wrapper[0].removeChild(n[0]),e.$obj.removeClass("cbp-animation-"+e.options.animationType),e.blocks.each(function(e,n){t(n).data("cbp").wrapper[0].style[o["private"].animationDelay]=""}),e.filterFinish()}e.blocksAreSorted&&e.sortBlocks(i,"top","left"),i.children(".cbp-item-wrapper").each(function(t,e){e.style[o["private"].animationDelay]=50*t+"ms"}),requestAnimationFrame(function(){e.$obj.addClass("cbp-animation-"+e.options.animationType),e.blocksOff.addClass("cbp-item-off"),e.blocksOn.removeClass("cbp-item-off").each(function(e,n){var i=t(n).data("cbp");i.left=i.leftNew,i.top=i.topNew,n.style.left=i.left+"px",n.style.top=i.top+"px",i.wrapper[0].style[o["private"].animationDelay]=50*e+"ms"});var n=e.blocksOn.length,r=i.length;0===n&&0===r?a():n<r?i.last().children(".cbp-item-wrapper").one(o["private"].animationend,a):e.blocksOn.last().data("cbp").wrapper.one(o["private"].animationend,a),e.resizeMainContainer()})},a.prototype.destroy=function(){var t=this.parent;t.$obj.removeClass("cbp-animation-"+t.options.animationType)},o.plugins.animationCloneDelay=function(e){return!o["private"].modernBrowser||t.inArray(e.options.animationType,["3dflip","flipOutDelay","foldLeft","frontRow","rotateRoom","rotateSides","scaleDown","slideDelay","unfold"])<0?null:new a(e)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;function a(t){this.parent=t,t.filterLayout=this.filterLayout}a.prototype.filterLayout=function(){var e=this,n=e.$ul[0].cloneNode(!0);function i(){e.wrapper[0].removeChild(n),e.$obj.removeClass("cbp-animation-"+e.options.animationType),e.filterFinish()}n.setAttribute("class","cbp-wrapper-helper"),e.wrapper[0].insertBefore(n,e.$ul[0]),requestAnimationFrame(function(){e.$obj.addClass("cbp-animation-"+e.options.animationType),e.blocksOff.addClass("cbp-item-off"),e.blocksOn.removeClass("cbp-item-off").each(function(e,n){var i=t(n).data("cbp");i.left=i.leftNew,i.top=i.topNew,n.style.left=i.left+"px",n.style.top=i.top+"px"}),e.blocksOn.length?e.$ul.one(o["private"].animationend,i):e.blocksOnInitial.length?t(n).one(o["private"].animationend,i):i(),e.resizeMainContainer()})},a.prototype.destroy=function(){var t=this.parent;t.$obj.removeClass("cbp-animation-"+t.options.animationType)},o.plugins.animationWrapper=function(e){return!o["private"].modernBrowser||t.inArray(e.options.animationType,["bounceBottom","bounceLeft","bounceTop","moveLeft"])<0?null:new a(e)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;function a(t){var e=this,n=t.options;e.parent=t,e.captionOn=n.caption,t.registerEvent("onMediaQueries",function(t){t&&t.hasOwnProperty("caption")?e.captionOn!==t.caption&&(e.destroy(),e.captionOn=t.caption,e.init()):e.captionOn!==n.caption&&(e.destroy(),e.captionOn=n.caption,e.init())}),e.init()}a.prototype.init=function(){var t=this;""!=t.captionOn&&("expand"===t.captionOn||o["private"].modernBrowser||(t.parent.options.caption=t.captionOn="minimal"),t.parent.$obj.addClass("cbp-caption-active cbp-caption-"+t.captionOn))},a.prototype.destroy=function(){this.parent.$obj.removeClass("cbp-caption-active cbp-caption-"+this.captionOn)},o.plugins.caption=function(t){return new a(t)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;function a(e){this.parent=e,e.registerEvent("initFinish",function(){e.$obj.on("click.cbp",".cbp-caption-defaultWrap",function(n){if(n.preventDefault(),!e.isAnimating){e.isAnimating=!0;var i=t(this),o=i.next(),a=i.parent(),r={position:"relative",height:o.outerHeight(!0)},s={position:"relative",height:0};if(e.$obj.addClass("cbp-caption-expand-active"),a.hasClass("cbp-caption-expand-open")){var l=s;s=r,r=l,a.removeClass("cbp-caption-expand-open")}o.css(r),e.$obj.one("pluginResize.cbp",function(){e.isAnimating=!1,e.$obj.removeClass("cbp-caption-expand-active"),0===r.height&&(a.removeClass("cbp-caption-expand-open"),o.attr("style",""))}),e.layoutAndAdjustment(!0),o.css(s),requestAnimationFrame(function(){a.addClass("cbp-caption-expand-open"),o.css(r),e.triggerEvent("gridAdjust"),e.triggerEvent("resizeGrid")})}})},!0)}a.prototype.destroy=function(){this.parent.$obj.find(".cbp-caption-defaultWrap").off("click.cbp").parent().removeClass("cbp-caption-expand-active")},o.plugins.captionExpand=function(t){return"expand"!==t.options.caption?null:new a(t)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;o.plugins.displayBottomToTop=function(e){return o["private"].modernBrowser&&"bottomToTop"===e.options.displayType&&0!==e.blocksOn.length?new function(e){e.registerEvent("initEndWrite",function(){if(!(e.width<=0)){var n=t.Deferred();e.pushQueue("delayFrame",n),e.blocksOn.each(function(t,n){n.style[o["private"].animationDelay]=t*e.options.displayTypeSpeed+"ms"}),e.$obj.addClass("cbp-displayType-bottomToTop"),e.blocksOn.last().one(o["private"].animationend,function(){e.$obj.removeClass("cbp-displayType-bottomToTop"),e.blocksOn.each(function(t,e){e.style[o["private"].animationDelay]=""}),n.resolve()})}},!0)}(e):null}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;o.plugins.displayFadeIn=function(e){return!o["private"].modernBrowser||"lazyLoading"!==e.options.displayType&&"fadeIn"!==e.options.displayType||0===e.blocksOn.length?null:new function(e){e.registerEvent("initEndWrite",function(){if(!(e.width<=0)){var n=t.Deferred();e.pushQueue("delayFrame",n),e.obj.style[o["private"].animationDuration]=e.options.displayTypeSpeed+"ms",e.$obj.addClass("cbp-displayType-fadeIn"),e.$obj.one(o["private"].animationend,function(){e.$obj.removeClass("cbp-displayType-fadeIn"),e.obj.style[o["private"].animationDuration]="",n.resolve()})}},!0)}(e)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;o.plugins.displayFadeInToTop=function(e){return o["private"].modernBrowser&&"fadeInToTop"===e.options.displayType&&0!==e.blocksOn.length?new function(e){e.registerEvent("initEndWrite",function(){if(!(e.width<=0)){var n=t.Deferred();e.pushQueue("delayFrame",n),e.obj.style[o["private"].animationDuration]=e.options.displayTypeSpeed+"ms",e.$obj.addClass("cbp-displayType-fadeInToTop"),e.$obj.one(o["private"].animationend,function(){e.$obj.removeClass("cbp-displayType-fadeInToTop"),e.obj.style[o["private"].animationDuration]="",n.resolve()})}},!0)}(e):null}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;o.plugins.displaySequentially=function(e){return o["private"].modernBrowser&&"sequentially"===e.options.displayType&&0!==e.blocksOn.length?new function(e){e.registerEvent("initEndWrite",function(){if(!(e.width<=0)){var n=t.Deferred();e.pushQueue("delayFrame",n),e.blocksOn.each(function(t,n){n.style[o["private"].animationDelay]=t*e.options.displayTypeSpeed+"ms"}),e.$obj.addClass("cbp-displayType-sequentially"),e.blocksOn.last().one(o["private"].animationend,function(){e.$obj.removeClass("cbp-displayType-sequentially"),e.blocksOn.each(function(t,e){e.style[o["private"].animationDelay]=""}),n.resolve()})}},!0)}(e):null}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;function a(e){var n=this;n.parent=e,n.filters=t(e.options.filters),n.filterData=[],e.registerEvent("afterPlugins",function(t){n.filterFromUrl(),n.registerFilter()}),e.registerEvent("resetFiltersVisual",function(){var i=e.options.defaultFilter.split("|");n.filters.each(function(e,n){var o=t(n).find(".cbp-filter-item");t.each(i,function(t,e){var n=o.filter('[data-filter="'+e+'"]');if(n.length)return n.addClass("cbp-filter-item-active").siblings().removeClass("cbp-filter-item-active"),i.splice(t,1),!1})}),e.defaultFilter=e.options.defaultFilter})}a.prototype.registerFilter=function(){var e=this,n=e.parent,i=n.defaultFilter.split("|");e.wrap=e.filters.find(".cbp-l-filters-dropdownWrap").on({"mouseover.cbp":function(){t(this).addClass("cbp-l-filters-dropdownWrap-open")},"mouseleave.cbp":function(){t(this).removeClass("cbp-l-filters-dropdownWrap-open")}}),e.filters.each(function(o,a){var r=t(a),s="*",l=r.find(".cbp-filter-item"),p={};r.hasClass("cbp-l-filters-dropdown")&&(p.wrap=r.find(".cbp-l-filters-dropdownWrap"),p.header=r.find(".cbp-l-filters-dropdownHeader"),p.headerText=p.header.text()),n.$obj.cubeportfolio("showCounter",l),t.each(i,function(t,e){if(l.filter('[data-filter="'+e+'"]').length)return s=e,i.splice(t,1),!1}),t.data(a,"filterName",s),e.filterData.push(a),e.filtersCallback(p,l.filter('[data-filter="'+s+'"]')),l.on("click.cbp",function(){var i=t(this);if(!i.hasClass("cbp-filter-item-active")&&!n.isAnimating){e.filtersCallback(p,i),t.data(a,"filterName",i.data("filter"));var o=t.map(e.filterData,function(e,n){var i=t.data(e,"filterName");return""!==i&&"*"!==i?i:null});o.length<1&&(o=["*"]);var r=o.join("|");n.defaultFilter!==r&&n.$obj.cubeportfolio("filter",r)}})})},a.prototype.filtersCallback=function(e,n){t.isEmptyObject(e)||(e.wrap.trigger("mouseleave.cbp"),e.headerText?e.headerText="":e.header.html(n.html())),n.addClass("cbp-filter-item-active").siblings().removeClass("cbp-filter-item-active")},a.prototype.filterFromUrl=function(){var t=/#cbpf=(.*?)([#\?&]|$)/gi.exec(location.href);null!==t&&(this.parent.defaultFilter=decodeURIComponent(t[1]))},a.prototype.destroy=function(){this.filters.find(".cbp-filter-item").off(".cbp"),this.wrap.off(".cbp")},o.plugins.filters=function(t){return""===t.options.filters?null:new a(t)}}(jQuery,window,document),function(t,e,n,i){"use strict";t.fn.cubeportfolio.constructor.plugins.changeGapOnMediaQueries=function(e){return new function(e){var n=e.options.gapVertical,i=e.options.gapHorizontal;e.registerEvent("onMediaQueries",function(o){e.options.gapVertical=o&&o.hasOwnProperty("gapVertical")?o.gapVertical:n,e.options.gapHorizontal=o&&o.hasOwnProperty("gapHorizontal")?o.gapHorizontal:i,e.blocks.each(function(n,i){var o=t(i).data("cbp");o.widthAndGap=o.width+e.options.gapVertical,o.heightAndGap=o.height+e.options.gapHorizontal})})}(e)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o={},a=t.fn.cubeportfolio.constructor;function r(e){var n=this;n.parent=e,n.options=t.extend({},o,n.parent.options.plugins.inlineSlider),n.runInit(),e.registerEvent("addItemsToDOM",function(){n.runInit()})}function s(t){var e=this;t.hasClass("cbp-slider-inline-ready")||(t.addClass("cbp-slider-inline-ready"),e.items=t.find(".cbp-slider-wrapper").children(".cbp-slider-item"),e.active=e.items.filter(".cbp-slider-item--active").index(),e.total=e.items.length-1,e.updateLeft(),t.find(".cbp-slider-next").on("click.cbp",function(t){t.preventDefault(),e.active<e.total?(e.active++,e.updateLeft()):e.active===e.total&&(e.active=0,e.updateLeft())}),t.find(".cbp-slider-prev").on("click.cbp",function(t){t.preventDefault(),e.active>0?(e.active--,e.updateLeft()):0===e.active&&(e.active=e.total,e.updateLeft())}))}s.prototype.updateLeft=function(){var t=this;t.items.removeClass("cbp-slider-item--active"),t.items.eq(t.active).addClass("cbp-slider-item--active"),t.items.each(function(e,n){n.style.left=e-t.active+"00%"})},r.prototype.runInit=function(){var e=this;e.parent.$obj.find(".cbp-slider-inline").not(".cbp-slider-inline-ready").each(function(n,i){var o=t(i),a=o.find(".cbp-slider-item--active").find("img")[0];a.hasAttribute("data-cbp-src")?e.parent.$obj.on("lazyLoad.cbp",function(t,e){e.src===a.src&&new s(o)}):new s(o)})},r.prototype.destroy=function(){this.parent.$obj.find(".cbp-slider-next").off("click.cbp"),this.parent.$obj.find(".cbp-slider-prev").off("click.cbp"),this.parent.$obj.off("lazyLoad.cbp"),this.parent.$obj.find(".cbp-slider-inline").each(function(e,n){var i=t(n);i.removeClass("cbp-slider-inline-ready");var o=i.find(".cbp-slider-item");o.removeClass("cbp-slider-item--active"),o.removeAttr("style"),o.eq(0).addClass("cbp-slider-item--active")})},a.plugins.inlineSlider=function(t){return new r(t)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o={loadingClass:"cbp-lazyload",threshold:400},a=t.fn.cubeportfolio.constructor,r=t(e);function s(e){var n=this;n.parent=e,n.options=t.extend({},o,n.parent.options.plugins.lazyLoad),e.registerEvent("initFinish",function(){n.loadImages(),e.registerEvent("resizeMainContainer",function(){n.loadImages()}),e.registerEvent("filterFinish",function(){n.loadImages()}),a["private"].lazyLoadScroll.initEvent({instance:n,fn:n.loadImages})},!0)}a["private"].lazyLoadScroll=new a["private"].publicEvents("scroll.cbplazyLoad",50),s.prototype.loadImages=function(){var e=this,n=e.parent.$obj.find("img").filter("[data-cbp-src]");0!==n.length&&(e.screenHeight=r.height(),n.each(function(n,i){var o=t(i.parentNode);if(e.isElementInScreen(i)){var a=i.getAttribute("data-cbp-src");null===e.parent.checkSrc(t("<img>").attr("src",a))?(e.removeLazyLoad(i,a),o.removeClass(e.options.loadingClass)):(o.addClass(e.options.loadingClass),t("<img>").on("load.cbp error.cbp",function(){e.removeLazyLoad(i,a,o)}).attr("src",a))}else o.addClass(e.options.loadingClass)}))},s.prototype.removeLazyLoad=function(e,n,i){var o=this;e.src=n,e.removeAttribute("data-cbp-src"),o.parent.removeAttrImage(e),o.parent.$obj.trigger("lazyLoad.cbp",e),i&&(a["private"].modernBrowser?t(e).one(a["private"].transitionend,function(){i.removeClass(o.options.loadingClass)}):i.removeClass(o.options.loadingClass))},s.prototype.isElementInScreen=function(t){var e=t.getBoundingClientRect(),n=e.bottom+this.options.threshold,i=this.screenHeight+n-(e.top-this.options.threshold);return n>=0&&n<=i},s.prototype.destroy=function(){a["private"].lazyLoadScroll.destroyEvent(this)},a.plugins.lazyLoad=function(t){return new s(t)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o={element:"",action:"click",loadItems:3},a=t.fn.cubeportfolio.constructor;function r(e){var n=this;n.parent=e,n.options=t.extend({},o,n.parent.options.plugins.loadMore),n.loadMore=t(n.options.element).find(".cbp-l-loadMore-link"),0!==n.loadMore.length&&(n.loadItems=n.loadMore.find(".cbp-l-loadMore-loadItems"),"0"===n.loadItems.text()&&n.loadMore.addClass("cbp-l-loadMore-stop"),e.registerEvent("filterStart",function(t){n.populateItems().then(function(){var e=n.items.filter(t).length;e>0?(n.loadMore.removeClass("cbp-l-loadMore-stop"),n.loadItems.html(e)):n.loadMore.addClass("cbp-l-loadMore-stop")})}),n[n.options.action]())}r.prototype.populateItems=function(){var e=this;return e.items?t.Deferred().resolve():(e.items=t(),t.ajax({url:e.loadMore.attr("href"),type:"GET",dataType:"HTML"}).done(function(n){var i=t.map(n.split(/\r?\n/),function(e,n){return t.trim(e)}).join("");0!==i.length&&t.each(t.parseHTML(i),function(n,i){t(i).hasClass("cbp-item")?e.items=e.items.add(i):t.each(i.children,function(n,i){t(i).hasClass("cbp-item")&&(e.items=e.items.add(i))})})}).fail(function(){e.items=null,e.loadMore.removeClass("cbp-l-loadMore-loading")}))},r.prototype.populateInsertItems=function(e){var n=this,i=[],o=n.parent.defaultFilter,a=0;n.items.each(function(e,r){if(a===n.options.loadItems)return!1;o&&"*"!==o?t(r).filter(o).length&&(i.push(r),n.items[e]=null,a++):(i.push(r),n.items[e]=null,a++)}),n.items=n.items.map(function(t,e){return e}),0!==i.length?n.parent.$obj.cubeportfolio("append",i,e):n.loadMore.removeClass("cbp-l-loadMore-loading").addClass("cbp-l-loadMore-stop")},r.prototype.click=function(){var t=this;function e(){t.loadMore.removeClass("cbp-l-loadMore-loading");var e,n=t.parent.defaultFilter;0===(e=n&&"*"!==n?t.items.filter(n).length:t.items.length)?t.loadMore.addClass("cbp-l-loadMore-stop"):t.loadItems.html(e)}t.loadMore.on("click.cbp",function(n){n.preventDefault(),t.parent.isAnimating||t.loadMore.hasClass("cbp-l-loadMore-stop")||(t.loadMore.addClass("cbp-l-loadMore-loading"),t.populateItems().then(function(){t.populateInsertItems(e)}))})},r.prototype.auto=function(){var n=this,i=t(e),o=!1;function r(){o||n.loadMore.hasClass("cbp-l-loadMore-stop")||(n.loadMore.offset().top-200>i.scrollTop()+i.height()||(o=!0,n.populateItems().then(function(){n.populateInsertItems(s)}).fail(function(){o=!1})))}function s(){var t,e=n.parent.defaultFilter;0===(t=e&&"*"!==e?n.items.filter(e).length:n.items.length)?n.loadMore.removeClass("cbp-l-loadMore-loading").addClass("cbp-l-loadMore-stop"):(n.loadItems.html(t),i.trigger("scroll.loadMore")),o=!1,0===n.items.length&&(a["private"].loadMoreScroll.destroyEvent(n),n.parent.$obj.off("filterComplete.cbp"))}a["private"].loadMoreScroll=new a["private"].publicEvents("scroll.loadMore",100),n.parent.$obj.one("initComplete.cbp",function(){n.loadMore.addClass("cbp-l-loadMore-loading").on("click.cbp",function(t){t.preventDefault()}),a["private"].loadMoreScroll.initEvent({instance:n,fn:function(){n.parent.isAnimating||r()}}),n.parent.$obj.on("filterComplete.cbp",function(){r()}),r()})},r.prototype.destroy=function(){this.loadMore.off(".cbp"),a["private"].loadMoreScroll&&a["private"].loadMoreScroll.destroyEvent(this)},a.plugins.loadMore=function(t){var e=t.options.plugins;return t.options.loadMore&&(e.loadMore||(e.loadMore={}),e.loadMore.element=t.options.loadMore),t.options.loadMoreAction&&(e.loadMore||(e.loadMore={}),e.loadMore.action=t.options.loadMoreAction),e.loadMore&&void 0!==e.loadMore.selector&&(e.loadMore.element=e.loadMore.selector,delete e.loadMore.selector),e.loadMore&&e.loadMore.element?new r(t):null}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor,a={delay:0},r={init:function(e,i){var o,r=this;if(r.cubeportfolio=e,r.type=i,r.isOpen=!1,r.options=r.cubeportfolio.options,"lightbox"===i&&(r.cubeportfolio.registerEvent("resizeWindow",function(){r.resizeImage()}),r.localOptions=t.extend({},a,r.cubeportfolio.options.plugins.lightbox)),"singlePageInline"!==i){if(r.createMarkup(),"singlePage"===i){if(r.cubeportfolio.registerEvent("resizeWindow",function(){if(r.options.singlePageStickyNavigation){var t=r.contentWrap[0].clientWidth;t>0&&(r.navigationWrap.width(t),r.navigation.width(t))}}),r.options.singlePageDeeplinking){r.url=location.href,"#"===r.url.slice(-1)&&(r.url=r.url.slice(0,-1));d=(u=r.url.split("#cbp=")).shift();if(t.each(u,function(e,n){if(r.cubeportfolio.blocksOn.each(function(e,i){var a=t(i).find(r.options.singlePageDelegate+'[href="'+n+'"]');if(a.length)return o=a,!1}),o)return!1}),o){r.url=d;var s=o,l=s.attr("data-cbp-singlePage"),p=[];l?p=s.closest(t(".cbp-item")).find('[data-cbp-singlePage="'+l+'"]'):r.cubeportfolio.blocksOn.each(function(e,n){var i=t(n);i.not(".cbp-item-off")&&i.find(r.options.singlePageDelegate).each(function(e,n){t(n).attr("data-cbp-singlePage")||p.push(n)})}),r.openSinglePage(p,o[0])}else if(u.length){var c=n.createElement("a");c.setAttribute("href",u[0]),r.openSinglePage([c],c)}}r.localOptions=t.extend({},a,r.cubeportfolio.options.plugins.singlePage)}}else{if(r.height=0,r.createMarkupSinglePageInline(),r.cubeportfolio.registerEvent("resizeGrid",function(){r.isOpen&&r.close()}),r.options.singlePageInlineDeeplinking){r.url=location.href,"#"===r.url.slice(-1)&&(r.url=r.url.slice(0,-1));var u,d=(u=r.url.split("#cbpi=")).shift();t.each(u,function(e,n){if(r.cubeportfolio.blocksOn.each(function(e,i){var a=t(i).find(r.options.singlePageInlineDelegate+'[href="'+n+'"]');if(a.length)return o=a,!1}),o)return!1}),o&&r.cubeportfolio.registerEvent("initFinish",function(){r.openSinglePageInline(r.cubeportfolio.blocksOn,o[0])},!0)}r.localOptions=t.extend({},a,r.cubeportfolio.options.plugins.singlePageInline)}},createMarkup:function(){var i=this,a="";if("singlePage"===i.type&&"left"!==i.options.singlePageAnimation&&(a=" cbp-popup-singlePage-"+i.options.singlePageAnimation),i.wrap=t("<div/>",{"class":"cbp-popup-wrap cbp-popup-"+i.type+a,"data-action":"lightbox"===i.type?"close":""}).on("click.cbp",function(e){if(!i.stopEvents){var n=t(e.target).attr("data-action");i[n]&&(i[n](),e.preventDefault())}}),"singlePage"===i.type?(i.contentWrap=t("<div/>",{"class":"cbp-popup-content-wrap"}).appendTo(i.wrap),"ios"===o["private"].browser&&i.contentWrap.css("overflow","auto"),i.content=t("<div/>",{"class":"cbp-popup-content"}).appendTo(i.contentWrap)):i.content=t("<div/>",{"class":"cbp-popup-content"}).appendTo(i.wrap),t("<div/>",{"class":"cbp-popup-loadingBox"}).appendTo(i.wrap),"ie8"===o["private"].browser&&(i.bg=t("<div/>",{"class":"cbp-popup-ie8bg","data-action":"lightbox"===i.type?"close":""}).appendTo(i.wrap)),"singlePage"===i.type&&!1===i.options.singlePageStickyNavigation?i.navigationWrap=t("<div/>",{"class":"cbp-popup-navigation-wrap"}).appendTo(i.contentWrap):i.navigationWrap=t("<div/>",{"class":"cbp-popup-navigation-wrap"}).appendTo(i.wrap),i.navigation=t("<div/>",{"class":"cbp-popup-navigation"}).appendTo(i.navigationWrap),i.closeButton=t("<div/>",{"class":"cbp-popup-close",title:"Close (Esc arrow key)","data-action":"close"}).appendTo(i.navigation),i.nextButton=t("<div/>",{"class":"cbp-popup-next",title:"Next (Right arrow key)","data-action":"next"}).appendTo(i.navigation),i.prevButton=t("<div/>",{"class":"cbp-popup-prev",title:"Previous (Left arrow key)","data-action":"prev"}).appendTo(i.navigation),"singlePage"===i.type){i.options.singlePageCounter&&(i.counter=t(i.options.singlePageCounter).appendTo(i.navigation),i.counter.text("")),i.content.on("click.cbp",i.options.singlePageDelegate,function(t){t.preventDefault();var e,o,a=i.dataArray.length,r=this.getAttribute("href");for(e=0;e<a;e++)if(i.dataArray[e].url===r){o=e;break}if(void 0===o){var s=n.createElement("a");s.setAttribute("href",r),i.dataArray=[{url:r,element:s}],i.counterTotal=1,i.nextButton.hide(),i.prevButton.hide(),i.singlePageJumpTo(0)}else i.singlePageJumpTo(o-i.current)});var r=!1;try{var s=Object.defineProperty({},"passive",{get:function(){r={passive:!0}}});e.addEventListener("testPassive",null,s),e.removeEventListener("testPassive",null,s)}catch(c){}var p="onwheel"in n.createElement("div")?"wheel":"mousewheel";i.contentWrap[0].addEventListener(p,function(t){t.stopImmediatePropagation()},r)}t(n).on("keydown.cbp",function(t){i.isOpen&&(i.stopEvents||(l&&t.stopImmediatePropagation(),37===t.keyCode?i.prev():39===t.keyCode?i.next():27===t.keyCode&&i.close()))})},createMarkupSinglePageInline:function(){var e=this;e.wrap=t("<div/>",{"class":"cbp-popup-singlePageInline"}).on("click.cbp",function(n){if(!e.stopEvents){var i=t(n.target).attr("data-action");i&&e[i]&&(e[i](),n.preventDefault())}}),e.content=t("<div/>",{"class":"cbp-popup-content"}).appendTo(e.wrap),e.navigation=t("<div/>",{"class":"cbp-popup-navigation"}).appendTo(e.wrap),e.closeButton=t("<div/>",{"class":"cbp-popup-close",title:"Close (Esc arrow key)","data-action":"close"}).appendTo(e.navigation)},destroy:function(){var e=this,i=t("body");t(n).off("keydown.cbp"),i.off("click.cbp",e.options.lightboxDelegate),i.off("click.cbp",e.options.singlePageDelegate),e.content.off("click.cbp",e.options.singlePageDelegate),e.cubeportfolio.$obj.off("click.cbp",e.options.singlePageInlineDelegate),e.cubeportfolio.$obj.off("click.cbp",e.options.lightboxDelegate),e.cubeportfolio.$obj.off("click.cbp",e.options.singlePageDelegate),e.cubeportfolio.$obj.removeClass("cbp-popup-isOpening"),e.cubeportfolio.$obj.find(".cbp-item").removeClass("cbp-singlePageInline-active"),e.wrap.remove()},openLightbox:function(i,o){var a,r,s=this,p=0,c=[];if(!s.isOpen){if(l=!0,s.isOpen=!0,s.stopEvents=!1,s.dataArray=[],s.current=null,null===(a=o.getAttribute("href")))throw new Error("HEI! Your clicked element doesn't have a href attribute.");t.each(i,function(e,n){var i,o=n.getAttribute("href"),r=o,l="isImage";if(-1===t.inArray(o,c)){if(a===o)s.current=p;else if(!s.options.lightboxGallery)return;if(/youtu\.?be/i.test(o)){var u=o.lastIndexOf("v=")+2;1===u&&(u=o.lastIndexOf("/")+1),i=o.substring(u),/autoplay=/i.test(i)||(i+="&autoplay=1"),r="//www.youtube.com/embed/"+(i=i.replace(/\?|&/,"?")),l="isYoutube"}else/vimeo\.com/i.test(o)?(i=o.substring(o.lastIndexOf("/")+1),/autoplay=/i.test(i)||(i+="&autoplay=1"),r="//player.vimeo.com/video/"+(i=i.replace(/\?|&/,"?")),l="isVimeo"):/www\.ted\.com/i.test(o)?(r="http://embed.ted.com/talks/"+o.substring(o.lastIndexOf("/")+1)+".html",l="isTed"):/soundcloud\.com/i.test(o)?(r=o,l="isSoundCloud"):/(\.mp4)|(\.ogg)|(\.ogv)|(\.webm)/i.test(o)?(r=-1!==o.indexOf("|")?o.split("|"):o.split("%7C"),l="isSelfHostedVideo"):/\.mp3$/i.test(o)&&(r=o,l="isSelfHostedAudio");s.dataArray.push({src:r,title:n.getAttribute(s.options.lightboxTitleSrc),type:l}),p++}c.push(o)}),s.counterTotal=s.dataArray.length,1===s.counterTotal?(s.nextButton.hide(),s.prevButton.hide(),s.dataActionImg=""):(s.nextButton.show(),s.prevButton.show(),s.dataActionImg='data-action="next"'),s.wrap.appendTo(n.body),s.scrollTop=t(e).scrollTop(),s.originalStyle=t("html").attr("style"),t("html").css({overflow:"hidden",marginRight:e.innerWidth-t(n).width()}),s.wrap.addClass("cbp-popup-transitionend"),s.wrap.show(),r=s.dataArray[s.current],s[r.type](r)}},openSinglePage:function(i,a){var r,s=this,l=0,p=[];if(!s.isOpen){if(s.cubeportfolio.singlePageInline&&s.cubeportfolio.singlePageInline.isOpen&&s.cubeportfolio.singlePageInline.close(),s.isOpen=!0,s.stopEvents=!1,s.dataArray=[],s.current=null,null===(r=a.getAttribute("href")))throw new Error("HEI! Your clicked element doesn't have a href attribute.");if(t.each(i,function(e,n){var i=n.getAttribute("href");-1===t.inArray(i,p)&&(r===i&&(s.current=l),s.dataArray.push({url:i,element:n}),l++),p.push(i)}),s.counterTotal=s.dataArray.length,1===s.counterTotal?(s.nextButton.hide(),s.prevButton.hide()):(s.nextButton.show(),s.prevButton.show()),s.wrap.appendTo(n.body),s.scrollTop=t(e).scrollTop(),s.contentWrap.scrollTop(0),s.wrap.show(),s.finishOpen=2,s.navigationMobile=t(),s.wrap.one(o["private"].transitionend,function(){t("html").css({overflow:"hidden",marginRight:e.innerWidth-t(n).width()}),s.wrap.addClass("cbp-popup-transitionend"),s.options.singlePageStickyNavigation&&(s.wrap.addClass("cbp-popup-singlePage-sticky"),s.navigationWrap.width(s.contentWrap[0].clientWidth)),s.finishOpen--,s.finishOpen<=0&&s.updateSinglePageIsOpen.call(s)}),"ie8"!==o["private"].browser&&"ie9"!==o["private"].browser||(t("html").css({overflow:"hidden",marginRight:e.innerWidth-t(n).width()}),s.wrap.addClass("cbp-popup-transitionend"),s.options.singlePageStickyNavigation&&(s.navigationWrap.width(s.contentWrap[0].clientWidth),setTimeout(function(){s.wrap.addClass("cbp-popup-singlePage-sticky")},1e3)),s.finishOpen--),s.wrap.addClass("cbp-popup-loading"),s.wrap.offset(),s.wrap.addClass("cbp-popup-singlePage-open"),s.options.singlePageDeeplinking&&(s.url=s.url.split("#cbp=")[0],location.href=s.url+"#cbp="+s.dataArray[s.current].url),t.isFunction(s.options.singlePageCallback)&&s.options.singlePageCallback.call(s,s.dataArray[s.current].url,s.dataArray[s.current].element),"ios"===o["private"].browser){var c=s.contentWrap[0];c.addEventListener("touchstart",function(){var t=c.scrollTop,e=c.scrollHeight,n=t+c.offsetHeight;0===t?c.scrollTop=1:n===e&&(c.scrollTop=t-1)})}}},openSinglePageInline:function(n,i,o){var a,r,s,l=this;if(o=o||!1,l.fromOpen=o,l.storeBlocks=n,l.storeCurrentBlock=i,l.isOpen)return r=l.cubeportfolio.blocksOn.index(t(i).closest(".cbp-item")),void(l.dataArray[l.current].url!==i.getAttribute("href")||l.current!==r?l.cubeportfolio.singlePageInline.close("open",{blocks:n,currentBlock:i,fromOpen:!0}):l.close());if(l.isOpen=!0,l.stopEvents=!1,l.dataArray=[],l.current=null,null===(a=i.getAttribute("href")))throw new Error("HEI! Your clicked element doesn't have a href attribute.");if(s=t(i).closest(".cbp-item")[0],n.each(function(t,e){s===e&&(l.current=t)}),l.dataArray[l.current]={url:a,element:i},t(l.dataArray[l.current].element).parents(".cbp-item").addClass("cbp-singlePageInline-active"),l.counterTotal=n.length,l.wrap.insertBefore(l.cubeportfolio.wrapper),l.topDifference=0,"top"===l.options.singlePageInlinePosition)l.blocksToMove=n,l.top=0;else if("bottom"===l.options.singlePageInlinePosition)l.blocksToMove=t(),l.top=l.cubeportfolio.height;else if("above"===l.options.singlePageInlinePosition){var p=t(n[l.current]),c=(u=p.data("cbp").top)+p.height();l.top=u,l.blocksToMove=t(),n.each(function(e,n){var i=t(n),o=i.data("cbp").top,a=o+i.height();a<=u||(o>=u&&(l.blocksToMove=l.blocksToMove.add(n)),o<u&&a>u&&(l.top=a+l.options.gapHorizontal,a-u>l.topDifference&&(l.topDifference=a-u+l.options.gapHorizontal)))}),l.top=Math.max(l.top-l.options.gapHorizontal,0)}else{var u;p=t(n[l.current]),c=(u=p.data("cbp").top)+p.height();l.top=c,l.blocksToMove=t(),n.each(function(e,n){var i=t(n),o=i.height(),a=i.data("cbp").top,r=a+o;r<=c||(a>=c-o/2?l.blocksToMove=l.blocksToMove.add(n):r>c&&a<c&&(r>l.top&&(l.top=r),r-c>l.topDifference&&(l.topDifference=r-c)))})}if(l.wrap[0].style.height=l.wrap.outerHeight(!0)+"px",l.deferredInline=t.Deferred(),l.options.singlePageInlineInFocus){l.scrollTop=t(e).scrollTop();var d=l.cubeportfolio.$obj.offset().top+l.top-100;l.scrollTop!==d?t("html,body").animate({scrollTop:d},350).promise().then(function(){l.resizeSinglePageInline(),l.deferredInline.resolve()}):(l.resizeSinglePageInline(),l.deferredInline.resolve())}else l.resizeSinglePageInline(),l.deferredInline.resolve();l.cubeportfolio.$obj.addClass("cbp-popup-singlePageInline-open"),l.wrap.css({top:l.top}),l.options.singlePageInlineDeeplinking&&(l.url=l.url.split("#cbpi=")[0],location.href=l.url+"#cbpi="+l.dataArray[l.current].url),t.isFunction(l.options.singlePageInlineCallback)&&l.options.singlePageInlineCallback.call(l,l.dataArray[l.current].url,l.dataArray[l.current].element)},resizeSinglePageInline:function(){var t=this;t.height=0===t.top||t.top===t.cubeportfolio.height?t.wrap.outerHeight(!0):t.wrap.outerHeight(!0)-t.options.gapHorizontal,t.height+=t.topDifference,t.storeBlocks.each(function(t,e){o["private"].modernBrowser?e.style[o["private"].transform]="":e.style.marginTop=""}),t.blocksToMove.each(function(e,n){o["private"].modernBrowser?n.style[o["private"].transform]="translate3d(0px, "+t.height+"px, 0)":n.style.marginTop=t.height+"px"}),t.cubeportfolio.obj.style.height=t.cubeportfolio.height+t.height+"px"},revertResizeSinglePageInline:function(){this.deferredInline=t.Deferred(),this.storeBlocks.each(function(t,e){o["private"].modernBrowser?e.style[o["private"].transform]="":e.style.marginTop=""}),this.cubeportfolio.obj.style.height=this.cubeportfolio.height+"px"},appendScriptsToWrap:function(t){var e=this,i=0,o=function(a){var r=n.createElement("script"),s=a.src;r.type="text/javascript",r.readyState?r.onreadystatechange=function(){"loaded"!=r.readyState&&"complete"!=r.readyState||(r.onreadystatechange=null,t[++i]&&o(t[i]))}:r.onload=function(){t[++i]&&o(t[i])},s?r.src=s:r.text=a.text,e.content[0].appendChild(r)};o(t[0])},updateSinglePage:function(e,n,i){var o,a=this;a.content.addClass("cbp-popup-content").removeClass("cbp-popup-content-basic"),!1===i&&a.content.removeClass("cbp-popup-content").addClass("cbp-popup-content-basic"),a.counter&&(o=t(a.getCounterMarkup(a.options.singlePageCounter,a.current+1,a.counterTotal)),a.counter.text(o.text())),a.fromAJAX={html:e,scripts:n},a.finishOpen--,a.finishOpen<=0&&a.updateSinglePageIsOpen.call(a)},updateSinglePageIsOpen:function(){var t,e=this;e.wrap.addClass("cbp-popup-ready"),e.wrap.removeClass("cbp-popup-loading"),e.content.html(e.fromAJAX.html),e.fromAJAX.scripts&&e.appendScriptsToWrap(e.fromAJAX.scripts),e.fromAJAX={},e.cubeportfolio.$obj.trigger("updateSinglePageStart.cbp"),(t=e.content.find(".cbp-slider")).length?(t.find(".cbp-slider-item").addClass("cbp-item"),e.slider=t.cubeportfolio({layoutMode:"slider",mediaQueries:[{width:1,cols:1}],gapHorizontal:0,gapVertical:0,caption:"",coverRatio:""})):e.slider=null,e.checkForSocialLinks(e.content),e.cubeportfolio.$obj.trigger("updateSinglePageComplete.cbp")},checkForSocialLinks:function(t){this.createFacebookShare(t.find(".cbp-social-fb")),this.createTwitterShare(t.find(".cbp-social-twitter")),this.createGooglePlusShare(t.find(".cbp-social-googleplus")),this.createPinterestShare(t.find(".cbp-social-pinterest"))},createFacebookShare:function(t){t.length&&!t.attr("onclick")&&t.attr("onclick","window.open('http://www.facebook.com/sharer.php?u="+encodeURIComponent(e.location.href)+"', '_blank', 'top=100,left=100,toolbar=0,status=0,width=620,height=400'); return false;")},createTwitterShare:function(t){t.length&&!t.attr("onclick")&&t.attr("onclick","window.open('https://twitter.com/intent/tweet?source="+encodeURIComponent(e.location.href)+"&text="+encodeURIComponent(n.title)+"', '_blank', 'top=100,left=100,toolbar=0,status=0,width=620,height=300'); return false;")},createGooglePlusShare:function(t){t.length&&!t.attr("onclick")&&t.attr("onclick","window.open('https://plus.google.com/share?url="+encodeURIComponent(e.location.href)+"', '_blank', 'top=100,left=100,toolbar=0,status=0,width=620,height=450'); return false;")},createPinterestShare:function(t){if(t.length&&!t.attr("onclick")){var n="",i=this.content.find("img")[0];i&&(n=i.src),t.attr("onclick","window.open('http://pinterest.com/pin/create/button/?url="+encodeURIComponent(e.location.href)+"&media="+n+"', '_blank', 'top=100,left=100,toolbar=0,status=0,width=620,height=400'); return false;")}},updateSinglePageInline:function(t,e){var n=this;n.content.html(t),e&&n.appendScriptsToWrap(e),n.cubeportfolio.$obj.trigger("updateSinglePageInlineStart.cbp"),0!==n.localOptions.delay?setTimeout(function(){n.singlePageInlineIsOpen.call(n)},n.localOptions.delay):n.singlePageInlineIsOpen.call(n)},singlePageInlineIsOpen:function(){var t=this;function e(){t.wrap.addClass("cbp-popup-singlePageInline-ready"),t.wrap[0].style.height="",t.resizeSinglePageInline(),t.cubeportfolio.$obj.trigger("updateSinglePageInlineComplete.cbp")}t.cubeportfolio.loadImages(t.wrap,function(){var n=t.content.find(".cbp-slider");n.length?(n.find(".cbp-slider-item").addClass("cbp-item"),n.one("initComplete.cbp",function(){t.deferredInline.done(e)}),n.on("pluginResize.cbp",function(){t.deferredInline.done(e)}),t.slider=n.cubeportfolio({layoutMode:"slider",displayType:"default",mediaQueries:[{width:1,cols:1}],gapHorizontal:0,gapVertical:0,caption:"",coverRatio:""})):(t.slider=null,t.deferredInline.done(e)),t.checkForSocialLinks(t.content)})},isImage:function(e){var n=this;new Image;n.tooggleLoading(!0),n.cubeportfolio.loadImages(t('<div><img src="'+e.src+'"></div>'),function(){n.updateImagesMarkup(e.src,e.title,n.getCounterMarkup(n.options.lightboxCounter,n.current+1,n.counterTotal)),n.tooggleLoading(!1)})},isVimeo:function(t){var e=this;e.updateVideoMarkup(t.src,t.title,e.getCounterMarkup(e.options.lightboxCounter,e.current+1,e.counterTotal))},isYoutube:function(t){var e=this;e.updateVideoMarkup(t.src,t.title,e.getCounterMarkup(e.options.lightboxCounter,e.current+1,e.counterTotal))},isTed:function(t){var e=this;e.updateVideoMarkup(t.src,t.title,e.getCounterMarkup(e.options.lightboxCounter,e.current+1,e.counterTotal))},isSoundCloud:function(t){var e=this;e.updateVideoMarkup(t.src,t.title,e.getCounterMarkup(e.options.lightboxCounter,e.current+1,e.counterTotal))},isSelfHostedVideo:function(t){var e=this;e.updateSelfHostedVideo(t.src,t.title,e.getCounterMarkup(e.options.lightboxCounter,e.current+1,e.counterTotal))},isSelfHostedAudio:function(t){var e=this;e.updateSelfHostedAudio(t.src,t.title,e.getCounterMarkup(e.options.lightboxCounter,e.current+1,e.counterTotal))},getCounterMarkup:function(t,e,n){if(!t.length)return"";var i={current:e,total:n};return t.replace(/\{\{current}}|\{\{total}}/gi,function(t){return i[t.slice(2,-2)]})},updateSelfHostedVideo:function(t,e,n){var i;this.wrap.addClass("cbp-popup-lightbox-isIframe");var o='<div class="cbp-popup-lightbox-iframe"><video controls="controls" height="auto" style="width: 100%">';for(i=0;i<t.length;i++)/(\.mp4)/i.test(t[i])?o+='<source src="'+t[i]+'" type="video/mp4">':/(\.ogg)|(\.ogv)/i.test(t[i])?o+='<source src="'+t[i]+'" type="video/ogg">':/(\.webm)/i.test(t[i])&&(o+='<source src="'+t[i]+'" type="video/webm">');o+='Your browser does not support the video tag.</video><div class="cbp-popup-lightbox-bottom">'+(e?'<div class="cbp-popup-lightbox-title">'+e+"</div>":"")+n+"</div></div>",this.content.html(o),this.wrap.addClass("cbp-popup-ready"),this.preloadNearbyImages()},updateSelfHostedAudio:function(t,e,n){this.wrap.addClass("cbp-popup-lightbox-isIframe");var i='<div class="cbp-popup-lightbox-iframe"><div class="cbp-misc-video"><audio controls="controls" height="auto" style="width: 75%"><source src="'+t+'" type="audio/mpeg">Your browser does not support the audio tag.</audio></div><div class="cbp-popup-lightbox-bottom">'+(e?'<div class="cbp-popup-lightbox-title">'+e+"</div>":"")+n+"</div></div>";this.content.html(i),this.wrap.addClass("cbp-popup-ready"),this.preloadNearbyImages()},updateVideoMarkup:function(t,e,n){this.wrap.addClass("cbp-popup-lightbox-isIframe");var i='<div class="cbp-popup-lightbox-iframe"><iframe src="'+t+'" frameborder="0" allowfullscreen scrolling="no"></iframe><div class="cbp-popup-lightbox-bottom">'+(e?'<div class="cbp-popup-lightbox-title">'+e+"</div>":"")+n+"</div></div>";this.content.html(i),this.wrap.addClass("cbp-popup-ready"),this.preloadNearbyImages()},updateImagesMarkup:function(t,e,n){var i=this;i.wrap.removeClass("cbp-popup-lightbox-isIframe");var o='<div class="cbp-popup-lightbox-figure"><img src="'+t+'" class="cbp-popup-lightbox-img" '+i.dataActionImg+' /><div class="cbp-popup-lightbox-bottom">'+(e?'<div class="cbp-popup-lightbox-title">'+e+"</div>":"")+n+"</div></div>";i.content.html(o),i.wrap.addClass("cbp-popup-ready"),i.resizeImage(),i.preloadNearbyImages()},next:function(){this[this.type+"JumpTo"](1)},prev:function(){this[this.type+"JumpTo"](-1)},lightboxJumpTo:function(t){var e,n=this;n.current=n.getIndex(n.current+t),n[(e=n.dataArray[n.current]).type](e)},singlePageJumpTo:function(e){var n=this;n.current=n.getIndex(n.current+e),t.isFunction(n.options.singlePageCallback)&&(n.resetWrap(),n.contentWrap.scrollTop(0),n.wrap.addClass("cbp-popup-loading"),n.slider&&o["private"].resize.destroyEvent(t.data(n.slider[0],"cubeportfolio")),n.options.singlePageCallback.call(n,n.dataArray[n.current].url,n.dataArray[n.current].element),n.options.singlePageDeeplinking&&(location.href=n.url+"#cbp="+n.dataArray[n.current].url))},resetWrap:function(){var t=this;"singlePage"===t.type&&t.options.singlePageDeeplinking&&(location.href=t.url+"#"),"singlePageInline"===t.type&&t.options.singlePageInlineDeeplinking&&(location.href=t.url+"#")},getIndex:function(t){return(t%=this.counterTotal)<0&&(t=this.counterTotal+t),t},close:function(n,i){var a=this;function r(){a.slider&&o["private"].resize.destroyEvent(t.data(a.slider[0],"cubeportfolio")),a.content.html(""),a.wrap.detach(),a.cubeportfolio.$obj.removeClass("cbp-popup-singlePageInline-open cbp-popup-singlePageInline-close"),a.isOpen=!1,"promise"===n&&t.isFunction(i.callback)&&i.callback.call(a.cubeportfolio)}function s(){var i=t(e).scrollTop();a.resetWrap(),t(e).scrollTop(i),a.options.singlePageInlineInFocus&&"promise"!==n?t("html,body").animate({scrollTop:a.scrollTop},350).promise().then(function(){r()}):r()}"singlePageInline"===a.type?"open"===n?(a.wrap.removeClass("cbp-popup-singlePageInline-ready"),t(a.dataArray[a.current].element).closest(".cbp-item").removeClass("cbp-singlePageInline-active"),a.isOpen=!1,a.openSinglePageInline(i.blocks,i.currentBlock,i.fromOpen)):(a.height=0,a.revertResizeSinglePageInline(),a.wrap.removeClass("cbp-popup-singlePageInline-ready"),a.cubeportfolio.$obj.addClass("cbp-popup-singlePageInline-close"),a.cubeportfolio.$obj.find(".cbp-item").removeClass("cbp-singlePageInline-active"),o["private"].modernBrowser?a.wrap.one(o["private"].transitionend,function(){s()}):s()):"singlePage"===a.type?(a.resetWrap(),a.stopScroll=!0,a.wrap.removeClass("cbp-popup-ready cbp-popup-transitionend cbp-popup-singlePage-open cbp-popup-singlePage-sticky"),t("html").css({overflow:"",marginRight:"",position:""}),t(e).scrollTop(a.scrollTop),"ie8"!==o["private"].browser&&"ie9"!==o["private"].browser||(a.slider&&o["private"].resize.destroyEvent(t.data(a.slider[0],"cubeportfolio")),a.content.html(""),a.wrap.detach(),a.isOpen=!1),a.wrap.one(o["private"].transitionend,function(){a.slider&&o["private"].resize.destroyEvent(t.data(a.slider[0],"cubeportfolio")),a.content.html(""),a.wrap.detach(),a.isOpen=!1})):(l=!1,a.originalStyle?t("html").attr("style",a.originalStyle):t("html").css({overflow:"",marginRight:""}),t(e).scrollTop(a.scrollTop),a.slider&&o["private"].resize.destroyEvent(t.data(a.slider[0],"cubeportfolio")),a.content.html(""),a.wrap.detach(),a.isOpen=!1)},tooggleLoading:function(t){this.stopEvents=t,this.wrap[t?"addClass":"removeClass"]("cbp-popup-loading")},resizeImage:function(){if(this.isOpen){var n=this.content.find("img"),i=n.parent(),o=t(e).height()-(i.outerHeight(!0)-i.height())-this.content.find(".cbp-popup-lightbox-bottom").outerHeight(!0);n.css("max-height",o+"px")}},preloadNearbyImages:function(){for(var t=this,e=[t.getIndex(t.current+1),t.getIndex(t.current+2),t.getIndex(t.current+3),t.getIndex(t.current-1),t.getIndex(t.current-2),t.getIndex(t.current-3)],n=e.length-1;n>=0;n--)"isImage"===t.dataArray[e[n]].type&&t.cubeportfolio.checkSrc(t.dataArray[e[n]])}};function s(t){var e=this;e.parent=t,!1===t.options.lightboxShowCounter&&(t.options.lightboxCounter=""),!1===t.options.singlePageShowCounter&&(t.options.singlePageCounter=""),t.registerEvent("initStartRead",function(){e.run()},!0)}var l=!1,p=!1,c=!1;s.prototype.run=function(){var e=this,i=e.parent,o=t(n.body);i.lightbox=null,i.options.lightboxDelegate&&!p&&(p=!0,i.lightbox=Object.create(r),i.lightbox.init(i,"lightbox"),o.on("click.cbp",i.options.lightboxDelegate,function(n){n.preventDefault();var o=t(this),a=o.attr("data-cbp-lightbox"),r=e.detectScope(o),s=r.data("cubeportfolio"),l=[];s?s.blocksOn.each(function(e,n){var o=t(n);o.not(".cbp-item-off")&&o.find(i.options.lightboxDelegate).each(function(e,n){a?t(n).attr("data-cbp-lightbox")===a&&l.push(n):l.push(n)})}):l=a?r.find(i.options.lightboxDelegate+"[data-cbp-lightbox="+a+"]"):r.find(i.options.lightboxDelegate),i.lightbox.openLightbox(l,o[0])})),i.singlePage=null,i.options.singlePageDelegate&&!c&&(c=!0,i.singlePage=Object.create(r),i.singlePage.init(i,"singlePage"),o.on("click.cbp",i.options.singlePageDelegate,function(n){n.preventDefault();var o=t(this),a=o.attr("data-cbp-singlePage"),r=e.detectScope(o),s=r.data("cubeportfolio"),l=[];s?s.blocksOn.each(function(e,n){var o=t(n);o.not(".cbp-item-off")&&o.find(i.options.singlePageDelegate).each(function(e,n){a?t(n).attr("data-cbp-singlePage")===a&&l.push(n):l.push(n)})}):l=a?r.find(i.options.singlePageDelegate+"[data-cbp-singlePage="+a+"]"):r.find(i.options.singlePageDelegate),i.singlePage.openSinglePage(l,o[0])})),i.singlePageInline=null,i.options.singlePageInlineDelegate&&(i.singlePageInline=Object.create(r),i.singlePageInline.init(i,"singlePageInline"),i.$obj.on("click.cbp",i.options.singlePageInlineDelegate,function(e){e.preventDefault();var n=t.data(this,"cbp-locked"),o=t.data(this,"cbp-locked",+new Date);(!n||o-n>300)&&i.singlePageInline.openSinglePageInline(i.blocksOn,this)}))},s.prototype.detectScope=function(e){var i,o,a;return(i=e.closest(".cbp-popup-singlePageInline")).length?(a=e.closest(".cbp",i[0])).length?a:i:(o=e.closest(".cbp-popup-singlePage")).length?(a=e.closest(".cbp",o[0])).length?a:o:(a=e.closest(".cbp")).length?a:t(n.body)},s.prototype.destroy=function(){var e=this.parent;t(n.body).off("click.cbp"),p=!1,c=!1,e.lightbox&&e.lightbox.destroy(),e.singlePage&&e.singlePage.destroy(),e.singlePageInline&&e.singlePageInline.destroy()},o.plugins.popUp=function(t){return new s(t)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o=t.fn.cubeportfolio.constructor;function a(e){var n=this;n.parent=e,n.searchInput=t(e.options.search),n.searchInput.each(function(e,n){var i=n.getAttribute("data-search");i||(i="*"),t.data(n,"searchData",{value:n.value,el:i})});var i=null;n.searchInput.on("keyup.cbp paste.cbp",function(e){e.preventDefault();var o=t(this);clearTimeout(i),i=setTimeout(function(){n.runEvent.call(n,o)},350)}),n.searchNothing=n.searchInput.siblings(".cbp-search-nothing").detach(),n.searchNothingHeight=null,n.searchNothingHTML=n.searchNothing.html(),n.searchInput.siblings(".cbp-search-icon").on("click.cbp",function(e){e.preventDefault(),n.runEvent.call(n,t(this).prev().val(""))})}a.prototype.runEvent=function(e){var n=this,i=e.val(),o=e.data("searchData"),a=new RegExp(i,"i");o.value===i||n.parent.isAnimating||(o.value=i,i.length>0?e.attr("value",i):e.removeAttr("value"),n.parent.$obj.cubeportfolio("filter",function(e){var r=e.filter(function(e,n){if(t(n).find(o.el).text().search(a)>-1)return!0});if(0===r.length&&n.searchNothing.length){var s=n.searchNothingHTML.replace("{{query}}",i);n.searchNothing.html(s),n.searchNothing.appendTo(n.parent.$obj),null===n.searchNothingHeight&&(n.searchNothingHeight=n.searchNothing.outerHeight(!0)),n.parent.registerEvent("resizeMainContainer",function(){n.parent.height=n.parent.height+n.searchNothingHeight,n.parent.obj.style.height=n.parent.height+"px"},!0)}else n.searchNothing.detach();return n.parent.triggerEvent("resetFiltersVisual"),r},function(){e.trigger("keyup.cbp")}))},a.prototype.destroy=function(){this.searchInput.off(".cbp"),this.searchInput.next(".cbp-search-icon").off(".cbp"),this.searchInput.each(function(e,n){t.removeData(n)})},o.plugins.search=function(t){return""===t.options.search?null:new a(t)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o={pagination:"",paginationClass:"cbp-pagination-active"},a=t.fn.cubeportfolio.constructor;function r(e){var n=this;n.parent=e,n.options=t.extend({},o,n.parent.options.plugins.slider);var i=t(n.options.pagination);i.length>0&&(n.parent.customPagination=i,n.parent.customPaginationItems=i.children(),n.parent.customPaginationClass=n.options.paginationClass,n.parent.customPaginationItems.on("click.cbp",function(e){e.preventDefault(),e.stopImmediatePropagation(),e.stopPropagation(),n.parent.sliderStopEvents||n.parent.jumpToSlider(t(this))})),n.parent.registerEvent("gridAdjust",function(){n.sliderMarkup.call(n.parent),n.parent.registerEvent("gridAdjust",function(){n.updateSlider.call(n.parent)})},!0)}r.prototype.sliderMarkup=function(){var e=this;e.sliderStopEvents=!1,e.sliderActive=0,e.$obj.one("initComplete.cbp",function(){e.$obj.addClass("cbp-mode-slider")}),e.nav=t("<div/>",{"class":"cbp-nav"}),e.nav.on("click.cbp","[data-slider-action]",function(n){if(n.preventDefault(),n.stopImmediatePropagation(),n.stopPropagation(),!e.sliderStopEvents){var i=t(this),o=i.attr("data-slider-action");e[o+"Slider"]&&e[o+"Slider"](i)}}),e.options.showNavigation&&(e.controls=t("<div/>",{"class":"cbp-nav-controls"}),e.navPrev=t("<div/>",{"class":"cbp-nav-prev","data-slider-action":"prev"}).appendTo(e.controls),e.navNext=t("<div/>",{"class":"cbp-nav-next","data-slider-action":"next"}).appendTo(e.controls),e.controls.appendTo(e.nav)),e.options.showPagination&&(e.navPagination=t("<div/>",{"class":"cbp-nav-pagination"}).appendTo(e.nav)),(e.controls||e.navPagination)&&e.nav.appendTo(e.$obj),e.updateSliderPagination(),e.options.auto&&(e.options.autoPauseOnHover&&(e.mouseIsEntered=!1,e.$obj.on("mouseenter.cbp",function(t){e.mouseIsEntered=!0,e.stopSliderAuto()}).on("mouseleave.cbp",function(t){e.mouseIsEntered=!1,e.startSliderAuto()})),e.startSliderAuto()),e.options.drag&&a["private"].modernBrowser&&e.dragSlider()},r.prototype.updateSlider=function(){this.updateSliderPosition(),this.updateSliderPagination()},r.prototype.destroy=function(){var t=this;t.parent.customPaginationItems&&t.parent.customPaginationItems.off(".cbp"),(t.parent.controls||t.parent.navPagination)&&(t.parent.nav.off(".cbp"),t.parent.nav.remove())},a.plugins.slider=function(t){return"slider"!==t.options.layoutMode?null:new r(t)}}(jQuery,window,document),function(t,e,n,i){"use strict";var o={element:""},a=t.fn.cubeportfolio.constructor;function r(e){var n=this;n.parent=e,n.options=t.extend({},o,n.parent.options.plugins.sort),n.element=t(n.options.element),0!==n.element.length&&(n.sort="",n.sortBy="string:asc",n.element.on("click.cbp",".cbp-sort-item",function(i){i.preventDefault(),n.target=i.target,t(n.target).hasClass("cbp-l-dropdown-item--active")||e.isAnimating||(n.processSort(),e.$obj.cubeportfolio("filter",e.defaultFilter))}),e.registerEvent("triggerSort",function(){n.target&&(n.processSort(),e.$obj.cubeportfolio("filter",e.defaultFilter))}),n.dropdownWrap=n.element.find(".cbp-l-dropdown-wrap").on({"mouseover.cbp":function(){t(this).addClass("cbp-l-dropdown-wrap--open")},"mouseleave.cbp":function(){t(this).removeClass("cbp-l-dropdown-wrap--open")}}),n.dropdownHeader=n.element.find(".cbp-l-dropdown-header"))}r.prototype.processSort=function(){var e=this,n=e.parent,i=(c=e.target).hasAttribute("data-sort"),o=c.hasAttribute("data-sortBy");if(i&&o)e.sort=c.getAttribute("data-sort"),e.sortBy=c.getAttribute("data-sortBy");else if(i)e.sort=c.getAttribute("data-sort");else{if(!o)return;e.sortBy=c.getAttribute("data-sortBy")}var a=e.sortBy.split(":"),r="string",s=1;if("int"===a[0]?r="int":"float"===a[0]&&(r="float"),"desc"===a[1]&&(s=-1),e.sort){var l=[];n.blocks.each(function(n,i){var o=t(i),a=o.find(e.sort).text();"int"===r&&(a=parseInt(a,10)),"float"===r&&(a=parseFloat(a,10)),l.push({sortText:a,data:o.data("cbp")})}),l.sort(function(t,e){var n=t.sortText,i=e.sortText;return"string"===r&&(n=n.toUpperCase(),i=i.toUpperCase()),n<i?-s:n>i?s:0}),t.each(l,function(t,e){e.data.index=t})}else{var p=[];-1===s&&(n.blocks.each(function(e,n){p.push(t(n).data("cbp").indexInitial)}),p.sort(function(t,e){return e-t})),n.blocks.each(function(e,n){var i=t(n).data("cbp");i.index=-1===s?p[i.indexInitial]:i.indexInitial})}n.sortBlocks(n.blocks,"index"),e.dropdownWrap.trigger("mouseleave.cbp");var c=t(e.target),u=t(e.target).parent();if(u.hasClass("cbp-l-dropdown-list"))e.dropdownHeader.html(c.html()),c.addClass("cbp-l-dropdown-item--active").siblings(".cbp-l-dropdown-item").removeClass("cbp-l-dropdown-item--active");else if(u.hasClass("cbp-l-direction")){0===c.index()?u.addClass("cbp-l-direction--second").removeClass("cbp-l-direction--first"):u.addClass("cbp-l-direction--first").removeClass("cbp-l-direction--second")}},r.prototype.destroy=function(){this.element.off("click.cbp")},a.plugins.sort=function(t){return new r(t)}}(jQuery,window,document);