<!DOCTYPE html>
<html lang="en">

<head>
    <title>Home Page</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Inter:100,200,300,400,500,600,700,800,900&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin,latin-ext,vietnamese">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Outfit:wght@500;600;700&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="css/tailwind/tailwind.min.css">
    <link rel="stylesheet" href="css/main.css">
    <link rel="stylesheet" href="css/custom.css">
    <link rel="icon" type="image/png" sizes="32x32" href="images/favicon-32x32.png">
    <script src="js/main.js"></script>
</head>

<body class="antialiased bg-body text-body font-body">
    <div class="">

        <section class="overflow-hidden">
            <div class="flex items-center justify-between px-8 py-5 bg-blue-500">
                <div class="w-auto">
                    <div class="flex flex-wrap items-center">
                        <div class="w-auto mr-14">
                            <a href="index.php">
                                <img src="https://static.shuffle.dev/uploads/files/59/59d8d6481e116259b9698d7279d55ac39df4770f/Emplio-white-w-orange-dots-1.png"
                                    alt="" class="w-36"></a>
                        </div>
                    </div>
                </div>
                <div class="w-auto hidden lg:block">
                    <ul class="flex items-center mr-10">
                        <li
                            class="font-heading mr-9 text-lg text-white hover:text-gray-200 ease-in duration-300 transition hover:text-red-100 tracking-px">
                            <a href="index.php">About us</a>
                        </li>
                        <li
                            class="font-heading mr-9 text-lg text-white hover:text-gray-200 transition ease-in duration-300 tracking-px hover:text-red-100">
                            <a href="students.php">Students</a>
                        </li>
                        <li
                            class="font-heading mr-9 text-lg text-white hover:text-gray-200 transition ease-in duration-300 tracking-px hover:text-red-100">
                            <a href="business.php">Businesses</a>
                        </li>

                        <li
                            class="text-white hover:text-gray-200 transition ease-in duration-300 hover:text-red-100 font-heading tracking-px text-sm text-lg">
                            <a href="contact-us.php">Contact us</a>
                        </li>
                    </ul>
                </div>
                <div class="w-auto">
                    <div class="flex flex-wrap items-center">
                        <div class="w-auto hidden lg:block">
                            <a href="waitlist.php"
                                class="group relative p-0.5 font-heading block w-full md:w-auto text-lg text-white font-medium bg-white overflow-hidden">
                                <div
                                    class="absolute top-0 left-0 transform -translate-y-full group-hover:-translate-y-0 h-full w-full bg-red-500 transition ease-in-out duration-500">
                                </div>
                                <div
                                    class="py-2 px-5 bg-blue-500 py-3.5 font-heading block tracking-px text-xs font-bold text-sm uppercase">
                                    <p class="relative z-10">JOIN THE WAITLIST</p>
                                </div>
                            </a>
                        </div>
                        <div class="w-auto lg:hidden">
                            <a href="#">
                                <svg class="navbar-burger text-blue-500" width="51" height="51" viewbox="0 0 56 56"
                                    fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect width="56" height="56" rx="28" fill="currentColor"></rect>
                                    <path d="M37 32H19M37 24H19" stroke="white" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="hidden navbar-menu fixed top-0 left-0 bottom-0 w-4/6 sm:max-w-xs z-50">
                <div class="navbar-backdrop fixed inset-0 bg-gray-800 opacity-80"></div>
                <nav class="relative z-10 px-9 py-8 bg-blue-500 h-full">
                    <div class="flex flex-wrap justify-between h-full">
                        <div class="w-full">
                            <div class="flex items-center justify-between -m-2">
                                <div class="w-auto p-2">
                                    <a class="inline-block" href="#">
                                        <img src="https://static.shuffle.dev/uploads/files/59/59d8d6481e116259b9698d7279d55ac39df4770f/Emplio-white-w-orange-dots-1.png"
                                            alt="" class="w-36"></a>
                                </div>
                                <div class="w-auto p-2">
                                    <a class="navbar-burger" href="#">
                                        <svg width="24" height="24" viewbox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M6 18L18 6M6 6L18 18" stroke="#ffffff" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg></a>
                                </div>
                            </div>
                        </div>
                        <div class="flex flex-col items-center text-center justify-center py-8 w-full">
                            <ul>
                                <li class="mb-12"><a
                                        class="font-heading font-medium text-lg text-white hover:text-red-100 tracking-px"
                                        href="index.php">About us</a></li>
                                <li class="mb-12"><a
                                        class="font-heading font-medium text-lg text-white hover:text-red-100 tracking-px"
                                        href="students.php">Students</a></li>

                                <li class="mb-12"><a
                                        class="font-heading font-medium text-lg text-white hover:text-red-100 tracking-px"
                                        href="business.php">Businesses</a></li>
                                <li><a class="font-heading font-medium text-lg text-white hover:text-red-100 tracking-px"
                                        href="contact-us.php">Contact us</a></li>
                            </ul>
                        </div>
                        <div class="flex flex-col justify-end w-full">
                            <div class="flex flex-wrap">
                                <div class="w-full">
                                    <button
                                        class="group relative p-0.5 font-heading block w-full text-lg text-white font-medium bg-white uppercase traxking-px overflow-hidden"
                                        href="waitlist.php">
                                        <div
                                            class="absolute top-0 left-0 transform -translate-y-full group-hover:-translate-y-0 h-full w-full bg-red-500 transition ease-in-out duration-500">
                                        </div>
                                        <div class="py-3.5 px-5 bg-blue-500">
                                            <p class="relative z-10">join the waitlist</p>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
            </div>
        </section>