<?php

/**

 * Plugin Name:   Kirki Toolkit

 * Plugin URI:    http://aristath.github.io/kirki

 * Description:   The ultimate WordPress Customizer Toolkit

 * Author:        Aristeides Stathopoulos

 * Author URI:    http://aristath.github.io

 * Version:       3.0.19

 * Text Domain:   kirki

 *

 * GitHub Plugin URI: aristath/kirki

 * GitHub Plugin URI: https://github.com/aristath/kirki

 *

 * @package     Kirki

 * @category    Core

 * @author      Aristeides Stathopoulos

 * @copyright   Copyright (c) 2017, Aristeides Stathopoulos

 * @license     http://opensource.org/licenses/https://opensource.org/licenses/MIT

 * @since       1.0

 */



// Exit if accessed directly.

if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



// No need to proceed if Kirki already exists.

if ( class_exists( 'Kirki' ) ) {

	return;

}



// Include the autoloader.

include_once dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'class-kirki-autoload.php';

new Kirki_Autoload();



if ( ! defined( 'KIRKI_PLUGIN_FILE' ) ) {

	define( 'KIRKI_PLUGIN_FILE', __FILE__ );

}



// Define the KIRKI_VERSION constant.

if ( ! defined( 'KIRKI_VERSION' ) ) {

	if ( ! function_exists( 'get_plugin_data' ) ) {

		include_once ABSPATH . 'wp-admin/includes/plugin.php';

	}

	$data = get_plugin_data( KIRKI_PLUGIN_FILE );

	$version = ( isset( $data['Version'] ) ) ? $data['Version'] : false;

	define( 'KIRKI_VERSION', $version );

}



// Make sure the path is properly set.

Kirki::$path = wp_normalize_path( dirname( __FILE__ ) );

Kirki_Init::set_url();



new Kirki_Controls();



if ( ! function_exists( 'Kirki' ) ) {

	/**

	 * Returns an instance of the Kirki object.

	 */

	function kirki() {

		$kirki = Kirki_Toolkit::get_instance();

		return $kirki;

	}

}



// Start Kirki.

global $kirki;

$kirki = kirki();



// Instantiate the modules.

$kirki->modules = new Kirki_Modules();



Kirki::$url = plugins_url( '', __FILE__ );



// Instantiate classes.

new Kirki();

new Kirki_L10n();



// Include deprecated functions & methods.

include_once wp_normalize_path( dirname( __FILE__ ) . '/core/deprecated.php' );



// Include the ariColor library.

include_once wp_normalize_path( dirname( __FILE__ ) . '/lib/class-aricolor.php' );



// Add an empty config for global fields.

Kirki::add_config( '' );



$custom_config_path = dirname( __FILE__ ) . '/custom-config.php';

$custom_config_path = wp_normalize_path( $custom_config_path );

if ( file_exists( $custom_config_path ) ) {

	include_once $custom_config_path;

}



// Add upgrade notifications.

include_once wp_normalize_path( dirname( __FILE__ ) . '/upgrade-notifications.php' );



/**

 * To enable tests, add this line to your wp-config.php file (or anywhere alse):

 * define( 'KIRKI_TEST', true );

 *

 * Please note that the example.php file is not included in the wordpress.org distribution

 * and will only be included in dev versions of the plugin in the github repository.

 */

if ( defined( 'KIRKI_TEST' ) && true === KIRKI_TEST && file_exists( dirname( __FILE__ ) . '/example.php' ) ) {

	include_once dirname( __FILE__ ) . '/example.php';

}

